/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.configurator;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteCommandEditor;
import com.eternalcode.core.libs.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.eternalcode.core.libs.dev.rollczi.litecommands.editor.Editor;
import com.eternalcode.core.libs.dev.rollczi.litecommands.meta.Meta;
import com.eternalcode.core.libs.dev.rollczi.litecommands.permission.PermissionSet;
import com.eternalcode.core.litecommand.configurator.config.Command;
import com.eternalcode.core.litecommand.configurator.config.CommandConfiguration;
import com.eternalcode.core.litecommand.configurator.config.SubCommand;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.bukkit.command.CommandSender;

@LiteCommandEditor
class CommandConfigurator
implements Editor<CommandSender> {
    private final CommandConfiguration commandConfiguration;

    @Inject
    CommandConfigurator(CommandConfiguration commandConfiguration) {
        this.commandConfiguration = commandConfiguration;
    }

    public CommandBuilder<CommandSender> edit(CommandBuilder<CommandSender> context) {
        Command command = this.commandConfiguration.commands.get(context.name());
        if (command == null) {
            return context;
        }
        for (String child : command.subCommands().keySet()) {
            SubCommand subCommand = command.subCommands().get(child);
            context = context.editChild(child, editor -> editor.name(subCommand.name()).aliases(subCommand.aliases()).applyMeta(CommandConfigurator.editPermissions(command.permissions())).enabled(subCommand.isEnabled()));
        }
        return context.name(command.name()).aliases(command.aliases()).applyMeta(CommandConfigurator.editPermissions(command.permissions())).enabled(command.isEnabled());
    }

    private static UnaryOperator<Meta> editPermissions(List<String> permissions) {
        return meta -> meta.listEditor(Meta.PERMISSIONS).clear().add((Object)new PermissionSet((Collection)permissions)).apply();
    }
}

