/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.injector.scan;

import com.eternalcode.core.injector.DependencyInjector;
import com.eternalcode.core.injector.annotations.Bean;
import com.eternalcode.core.injector.bean.BeanCandidate;
import com.eternalcode.core.injector.bean.LazyFieldBeanCandidate;
import com.eternalcode.core.injector.scan.ComponentBeanCandidateImpl;
import com.eternalcode.core.injector.scan.ComponentNameProvider;
import com.eternalcode.core.injector.scan.MethodBeanCandidate;
import com.eternalcode.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class DependencyScanner {
    private final DependencyInjector dependencyInjector;
    private final Map<Class<? extends Annotation>, ComponentNameProvider<?>> annotations = new HashMap();
    private final List<Predicate<Class<?>>> includedTypes = new ArrayList();

    public DependencyScanner(DependencyInjector dependencyInjector) {
        this.dependencyInjector = dependencyInjector;
    }

    @SafeVarargs
    public final DependencyScanner includeAnnotations(Class<? extends Annotation> ... annotationTypes) {
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            this.includeAnnotation(annotationType);
        }
        return this;
    }

    public DependencyScanner includeType(Predicate<Class<?>> predicate) {
        this.includedTypes.add(predicate);
        return this;
    }

    private DependencyScanner includeAnnotation(Class<? extends Annotation> annotationType) {
        this.annotations.put(annotationType, annotation -> "");
        return this;
    }

    public <A extends Annotation> DependencyScanner includeAnnotation(Class<A> annotationType, ComponentNameProvider<A> componentNameProvider) {
        this.annotations.put(annotationType, componentNameProvider);
        return this;
    }

    public List<BeanCandidate> scan(Package ... packages) {
        String[] packageNames = (String[])Arrays.stream(packages).map(onePackage -> onePackage.getName()).toArray(String[]::new);
        return this.scan(packageNames);
    }

    public List<BeanCandidate> scan(String ... packageNames) {
        List<Class<?>> classes = this.scanPackages(List.of(packageNames));
        ArrayList<BeanCandidate> beanCandidates = new ArrayList<BeanCandidate>();
        for (Class<?> clazz : classes) {
            boolean isIncluded = this.includedTypes.stream().allMatch(filter -> filter.test(clazz));
            if (!isIncluded) continue;
            beanCandidates.addAll(this.createBeanCandidates(clazz));
        }
        return beanCandidates;
    }

    private List<BeanCandidate> createBeanCandidates(Class<?> clazz) {
        ArrayList<BeanCandidate> beanCandidates = new ArrayList<BeanCandidate>();
        BeanCandidate beanCandidate = this.createBeanCandidate(clazz);
        if (beanCandidate != null) {
            beanCandidates.add(beanCandidate);
            List<BeanCandidate> otherCandidates = this.getFieldAndMethodCandidates(clazz);
            beanCandidates.addAll(otherCandidates);
        }
        return beanCandidates;
    }

    private BeanCandidate createBeanCandidate(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            BeanCandidate beanCandidate = this.createBeanCandidate(clazz, annotation);
            if (beanCandidate == null) continue;
            return beanCandidate;
        }
        return null;
    }

    private <A extends Annotation> BeanCandidate createBeanCandidate(Class<?> clazz, A annotation) {
        ComponentNameProvider<A> componentNameProvider = this.getComponentNameProvider(annotation);
        if (componentNameProvider == null) {
            return null;
        }
        return new ComponentBeanCandidateImpl<A>(this.dependencyInjector, clazz, annotation, componentNameProvider);
    }

    private List<BeanCandidate> getFieldAndMethodCandidates(Class<?> componentClass) {
        ArrayList<BeanCandidate> beanCandidates = new ArrayList<BeanCandidate>();
        for (Method method : componentClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Bean.class)) continue;
            Bean bean = method.getAnnotation(Bean.class);
            MethodBeanCandidate beanCandidate = new MethodBeanCandidate(this.dependencyInjector, componentClass, method, bean);
            beanCandidates.add(beanCandidate);
        }
        for (Field field : ReflectUtil.getAllSuperFields(componentClass)) {
            if (!field.isAnnotationPresent(Bean.class)) continue;
            Bean bean = field.getAnnotation(Bean.class);
            LazyFieldBeanCandidate beanCandidate = new LazyFieldBeanCandidate(this.dependencyInjector, componentClass, field, bean);
            beanCandidates.add(beanCandidate);
        }
        return beanCandidates;
    }

    @Nullable
    private <A extends Annotation> ComponentNameProvider<A> getComponentNameProvider(A annotation) {
        return this.annotations.get(annotation.annotationType());
    }

    private List<Class<?>> scanPackages(List<String> packages) {
        return packages.stream().map(packageName -> this.scanPackage((String)packageName)).flatMap(classesFromPackage -> classesFromPackage.stream()).toList();
    }

    private List<Class<?>> scanPackage(String packageName) {
        return ReflectUtil.scanClasses(packageName, this.getClass().getClassLoader());
    }
}

