/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.speed;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.speed.SpeedType;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Player;

@Command(name="speed")
@Permission(value={"eternalcore.speed"})
class SpeedCommand {
    private final NoticeService noticeService;

    @Inject
    SpeedCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Set speed depending on whether you flying or walking by specified amount"}, arguments={"<speed>"})
    void execute(@Sender Player player, @Arg(value="speed") Double speed) {
        this.setSpeed(player, speed);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> player.isFlying() ? translation.speed().flySpeedSet() : translation.speed().walkSpeedSet())).placeholder("{SPEED}", String.valueOf(speed))).player(player.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Set speed depending on whether the player is flying or walking by specified amount"}, arguments={"<speed> <player>"})
    void execute(@Sender Viewer viewer, @Arg(value="speed") Double speed, @Arg Player target) {
        this.setSpeed(target, speed);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> target.isFlying() ? translation.speed().flySpeedSet() : translation.speed().walkSpeedSet())).placeholder("{SPEED}", String.valueOf(speed))).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> target.isFlying() ? translation.speed().flySpeedSetForTargetPlayer() : translation.speed().walkSpeedSetForTargetPlayer())).placeholder("{PLAYER}", target.getName())).placeholder("{SPEED}", String.valueOf(speed))).viewer(viewer)).send();
    }

    @Execute
    @DescriptionDocs(description={"Set speed of walking or flying to specified amount"}, arguments={"<type> <speed>"})
    void execute(@Sender Player player, @Arg SpeedType speedType, @Arg(value="speed") Double speed) {
        this.setSpeed(player, speedType, speed);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> speedType == SpeedType.WALK ? translation.speed().walkSpeedSet() : translation.speed().flySpeedSet())).placeholder("{SPEED}", String.valueOf(speed))).player(player.getUniqueId())).send();
    }

    @Execute
    @DescriptionDocs(description={"Set speed of walking or flying to specified amount and player"}, arguments={"<type> <speed> <player>"})
    void execute(@Sender Viewer viewer, @Arg SpeedType speedType, @Arg(value="speed") Double speed, @Arg Player target) {
        this.setSpeed(target, speedType, speed);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> speedType == SpeedType.WALK ? translation.speed().walkSpeedSet() : translation.speed().flySpeedSet())).placeholder("{SPEED}", String.valueOf(speed))).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> speedType == SpeedType.WALK ? translation.speed().walkSpeedSetForTargetPlayer() : translation.speed().flySpeedSetForTargetPlayer())).placeholder("{PLAYER}", target.getName())).placeholder("{SPEED}", String.valueOf(speed))).viewer(viewer)).send();
    }

    void setSpeed(Player player, double speed) {
        float scaled = (float)(speed / 10.0);
        if (player.isFlying()) {
            player.setFlySpeed(scaled);
        } else {
            player.setWalkSpeed(scaled);
        }
    }

    void setSpeed(Player player, SpeedType speedType, double speed) {
        float scaled = (float)(speed / 10.0);
        switch (speedType) {
            case WALK: {
                player.setWalkSpeed(scaled);
                break;
            }
            case FLY: {
                player.setFlySpeed(scaled);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)speedType));
            }
        }
    }
}

