/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.playtime;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.DurationUtil;
import java.time.Duration;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

@Command(name="playtime")
@Permission(value={"eternalcore.playtime"})
class PlaytimeCommand {
    private final NoticeService noticeService;

    @Inject
    PlaytimeCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Shows your playtime"})
    void self(@Sender Player player) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.playtime().self())).placeholder("{PLAYTIME}", this.formatPlaytime(player))).player(player.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.playtime.other"})
    @DescriptionDocs(description={"Shows playtime of a player"}, arguments={"<player>"})
    void other(@Sender Player player, @Arg Player target) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.playtime().other())).placeholder("{PLAYER}", target.getName())).placeholder("{PLAYTIME}", this.formatPlaytime(target))).player(player.getUniqueId())).send();
    }

    private String formatPlaytime(Player player) {
        int ticks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        Duration playtime = Duration.ofSeconds((long)ticks / 20L);
        return DurationUtil.format(playtime, true);
    }
}

