/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.msg.toggle;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.msg.toggle.MsgState;
import com.eternalcode.core.feature.msg.toggle.MsgToggleService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="msgtoggle")
@Permission(value={"eternalcore.msgtoggle"})
class MsgToggleCommand {
    private final MsgToggleService msgToggleService;
    private final NoticeService noticeService;

    @Inject
    MsgToggleCommand(MsgToggleService msgToggleService, NoticeService noticeService) {
        this.msgToggleService = msgToggleService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Toggle receiving private messages"})
    void execute(@Sender Player sender) {
        UUID player = sender.getUniqueId();
        this.msgToggleService.toggleState(player).thenAccept(toggledState -> this.noticePlayer((MsgState)((Object)toggledState), player));
    }

    @Execute(name="enable")
    @DescriptionDocs(description={"Enable receiving private messages"})
    void executeEnable(@Sender Player sender, @Arg MsgState state) {
        UUID player = sender.getUniqueId();
        this.msgToggleService.setState(player, MsgState.ENABLED).thenAccept(ignored -> this.noticePlayer(MsgState.ENABLED, player));
    }

    @Execute(name="disable")
    @DescriptionDocs(description={"Disable receiving private messages"})
    void executeDisable(@Sender Player sender) {
        UUID player = sender.getUniqueId();
        this.msgToggleService.setState(player, MsgState.DISABLED).thenAccept(ignored -> this.noticePlayer(MsgState.DISABLED, player));
    }

    @Execute
    @Permission(value={"eternalcore.msgtoggle.other"})
    @DescriptionDocs(description={"Switch receiving private messages for other player"}, arguments={"<player>"})
    void other(@Sender CommandSender sender, @Arg Player target) {
        UUID player = target.getUniqueId();
        this.msgToggleService.toggleState(player).thenAccept(toggledState -> this.noticeOtherPlayer(sender, (MsgState)((Object)toggledState), target));
    }

    @Execute
    @Permission(value={"eternalcore.msgtoggle.other"})
    @DescriptionDocs(description={"Switch receiving private messages for other player"}, arguments={"<player>  <toggle>"})
    void other(@Sender CommandSender sender, @Arg Player target, @Arg MsgState state) {
        UUID player = target.getUniqueId();
        this.msgToggleService.setState(player, state).thenAccept(ignored -> this.noticeOtherPlayer(sender, state, target));
    }

    private void noticeOtherPlayer(CommandSender sender, MsgState state, Player target) {
        this.noticePlayer(state, target.getUniqueId());
        if (sender.equals((Object)target)) {
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().sender(sender).notice(translation -> state == MsgState.DISABLED ? translation.msg().otherMessagesDisabled() : translation.msg().otherMessagesEnabled())).placeholder("{PLAYER}", target.getName())).send();
    }

    private void noticePlayer(MsgState state, UUID player) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player)).notice(translation -> state == MsgState.ENABLED ? translation.msg().selfMessagesEnabled() : translation.msg().selfMessagesDisabled())).send();
    }
}

