/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.itemedit;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.adventure.AdventureUtil;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.join.Join;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.net.kyori.adventure.text.Component;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Command(name="itemlore")
@Permission(value={"eternalcore.itemlore"})
class ItemLoreCommand {
    private final NoticeService noticeService;
    private final MiniMessage miniMessage;

    @Inject
    ItemLoreCommand(NoticeService noticeService, MiniMessage miniMessage) {
        this.noticeService = noticeService;
        this.miniMessage = miniMessage;
    }

    @Execute
    @DescriptionDocs(description={"Sets lore of item in hand"}, arguments={"<line> <text>"})
    void execute(@Sender Player player, @Arg(value="item-lore") int line, @Join String text) {
        ItemStack itemStack = this.validateItemFromMainHand(player);
        if (itemStack == null) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.argument().noItem(), new Formatter[0]);
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<String> lore = itemMeta.getLore();
        ArrayList<String> arrayList = lore = lore == null ? new ArrayList<String>() : new ArrayList(lore);
        while (lore.size() <= line) {
            lore.add("");
        }
        lore.set(line, AdventureUtil.SECTION_SERIALIZER.serialize(AdventureUtil.resetItalic((Component)this.miniMessage.deserialize((Object)text))));
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.itemEdit().itemChangeLoreMessage())).placeholder("{ITEM_LORE}", text)).player(player.getUniqueId())).send();
    }

    @Execute(name="remove")
    @DescriptionDocs(description={"Removes a specific line of lore from the item in hand"}, arguments={"<line>"})
    void remove(@Sender Player player, @Arg(value="item-lore") int line) {
        ItemStack itemStack = this.validateItemFromMainHand(player);
        if (itemStack == null) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.argument().noItem(), new Formatter[0]);
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        List lore = itemMeta.getLore();
        if (lore == null || lore.isEmpty()) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().noLore(), new Formatter[0]);
            return;
        }
        if (line < 0 || line >= lore.size()) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().invalidLoreLine(), new Formatter[0]);
            return;
        }
        lore.remove(line);
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.itemEdit().itemLoreLineRemoved())).placeholder("{LINE}", String.valueOf(line + 1))).send();
    }

    @Execute(name="clear")
    @DescriptionDocs(description={"Clears all lore from the item in hand"})
    void clear(@Sender Player player) {
        ItemStack itemStack = this.validateItemFromMainHand(player);
        if (itemStack == null) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.argument().noItem(), new Formatter[0]);
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(new ArrayList());
        itemStack.setItemMeta(itemMeta);
        this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().itemClearLoreMessage(), new Formatter[0]);
    }

    private ItemStack validateItemFromMainHand(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (itemStack.getType() == Material.AIR || itemStack.getItemMeta() == null) {
            return null;
        }
        return itemStack;
    }
}

