/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.give;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.give.GiveService;
import com.eternalcode.core.feature.give.GiveSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.optional.OptionalArg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.MaterialUtil;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="give")
@Permission(value={"eternalcore.give"})
class GiveCommand {
    private final NoticeService noticeService;
    private final GiveService giveService;
    private final GiveSettings giveSettings;

    @Inject
    GiveCommand(NoticeService noticeService, GiveService giveService, GiveSettings giveSettings) {
        this.noticeService = noticeService;
        this.giveService = giveService;
        this.giveSettings = giveSettings;
    }

    @Execute
    @DescriptionDocs(description={"Gives you an item"}, arguments={"<item>"})
    void execute(@Sender Player player, @Arg Material material) {
        this.execute(player, material, this.giveSettings.defaultGiveAmount());
    }

    @Execute
    @DescriptionDocs(description={"Gives an item to another player"}, arguments={"<player> <item>"})
    void execute(@Sender CommandSender sender, @OptionalArg Player target, @Arg Material material) {
        this.execute(sender, target, material, this.giveSettings.defaultGiveAmount());
    }

    @Execute
    @DescriptionDocs(description={"Gives you an item with a custom amount"}, arguments={"<item> [amount]"})
    void execute(@Sender Player player, @Arg Material material, @OptionalArg(value="amount") int amount) {
        boolean isSuccess = this.giveService.giveItem((CommandSender)player, player, material, amount);
        if (isSuccess) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().placeholder("{ITEM}", MaterialUtil.format(material))).notice(translation -> translation.give().itemGivenByAdmin())).player(player.getUniqueId())).send();
        }
    }

    @Execute
    @DescriptionDocs(description={"Gives an item with a custom amount to another player"}, arguments={"<player> <item> <amount>"})
    void execute(@Sender CommandSender sender, @OptionalArg Player target, @Arg Material material, @OptionalArg(value="amount") int amount) {
        boolean isSuccess = this.giveService.giveItem(sender, target, material, amount);
        if (!isSuccess) {
            return;
        }
        String formattedMaterial = MaterialUtil.format(material);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().placeholder("{ITEM}", formattedMaterial)).notice(translation -> translation.give().itemGivenByAdmin())).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().placeholder("{ITEM}", formattedMaterial)).placeholder("{PLAYER}", target.getName())).notice(translation -> translation.give().itemGivenToTargetPlayer())).sender(sender).send();
    }
}

