/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.burn;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.Optional;
import org.bukkit.entity.Player;

@Command(name="burn", aliases={"ignite"})
@Permission(value={"eternalcore.burn"})
public class BurnCommand {
    private static final int DEFAULT_BURN_TICK_DURATION = 100;
    private final NoticeService noticeService;

    @Inject
    public BurnCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Burns yourself for a specified amount of ticks."}, arguments={"[ticks]"})
    void self(@Sender Player sender, @Arg Optional<Integer> ticks) {
        this.burn(sender, sender, ticks);
    }

    @Execute
    @Permission(value={"eternalcore.burn.other"})
    @DescriptionDocs(description={"Burns target for a specified amount of ticks."}, arguments={"<target> [ticks]"})
    void other(@Sender Player sender, @Arg Player target, @Arg Optional<Integer> ticks) {
        this.burn(sender, target, ticks);
    }

    private void burn(Player sender, Player target, Optional<Integer> ticks) {
        int actualTicks = ticks.orElse(100);
        if (actualTicks <= 0) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).notice(translation -> translation.argument().numberBiggerThanZero())).send();
            return;
        }
        target.setFireTicks(actualTicks);
        String ticksString = String.valueOf(actualTicks);
        if (sender.equals((Object)target)) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).placeholder("{TICKS}", ticksString)).notice(translation -> translation.burn().burnedSelf())).send();
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(sender.getUniqueId())).placeholder("{PLAYER}", target.getName())).placeholder("{TICKS}", ticksString)).notice(translation -> translation.burn().burnedOther())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).placeholder("{TICKS}", ticksString)).notice(translation -> translation.burn().burnedSelf())).send();
    }
}

