/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.broadcast;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.broadcast.BroadcastSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.notice.Notice;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.flag.Flag;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.join.Join;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.net.kyori.adventure.bossbar.BossBar;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.time.Duration;
import java.util.function.Function;

@Command(name="broadcast", aliases={"bc"})
@Permission(value={"eternalcore.broadcast"})
class BroadcastCommand {
    private final NoticeService noticeService;
    private final BroadcastSettings settings;

    @Inject
    BroadcastCommand(NoticeService noticeService, BroadcastSettings settings) {
        this.noticeService = noticeService;
        this.settings = settings;
    }

    @Execute
    @DescriptionDocs(description={"Broadcasts a CHAT message to all players."}, arguments={"[-raw] <text>"})
    void executeChat(@Flag(value={"-raw"}) boolean raw, @Join String text) {
        this.sendBroadcast(formatted -> Notice.chat((String[])new String[]{formatted}), text, raw);
    }

    @Execute(name="title")
    @DescriptionDocs(description={"Broadcasts a combined title message to all players."}, arguments={"[-raw] <text>"})
    void executeTitle(@Flag(value={"-raw"}) boolean raw, @Join String text) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> Notice.title((String)(raw ? " " : translation.broadcast().titleHeader()), (String)text, (Duration)this.settings.titleFadeIn(), (Duration)this.settings.titleStay(), (Duration)this.settings.titleFadeOut()))).onlinePlayers()).send();
    }

    @Execute(name="actionbar")
    @DescriptionDocs(description={"Broadcasts a ACTIONBAR message to all players."}, arguments={"[-raw] <text>"})
    void executeActionBar(@Flag(value={"-raw"}) boolean raw, @Join String text) {
        this.sendBroadcast(formatted -> Notice.actionbar((String)formatted), text, raw);
    }

    @Execute(name="bossbar")
    @DescriptionDocs(description={"Broadcasts a BOSSBAR message to all players."}, arguments={"[-raw] <color> <duration> <text>"})
    void executeBossBar(@Flag(value={"-raw"}) boolean raw, @Arg BossBar.Color color, @Arg Duration duration, @Join String text) {
        this.sendBroadcast(formatted -> Notice.bossBar((BossBar.Color)color, (Duration)duration, (double)1.0, (String)formatted), text, raw);
    }

    private void sendBroadcast(Function<String, Notice> converter, String text, boolean raw) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> (Notice)converter.apply(raw ? text : translation.broadcast().messageFormat()))).placeholder("{BROADCAST}", text)).onlinePlayers()).send();
    }
}

