/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.annotations.scan.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AnnotationUtil {
    public static <A extends Annotation> List<A> scanForAnnotations(Class<?> classToScan, Class<A> annotationClass) {
        ArrayList<A> annotations = new ArrayList<A>();
        A annotation = classToScan.getAnnotation(annotationClass);
        if (annotation != null) {
            annotations.add(annotation);
        }
        for (Method method : classToScan.getDeclaredMethods()) {
            A methodAnnotation = method.getAnnotation(annotationClass);
            if (methodAnnotation == null) continue;
            annotations.add(methodAnnotation);
        }
        for (AccessibleObject accessibleObject : classToScan.getDeclaredFields()) {
            A fieldAnnotation = ((Field)accessibleObject).getAnnotation(annotationClass);
            if (fieldAnnotation == null) continue;
            annotations.add(fieldAnnotation);
        }
        return annotations;
    }
}

