/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.injector.bean;

import com.eternalcode.core.injector.bean.BeanCandidate;
import com.eternalcode.core.libs.dev.rollczi.litecommands.priority.MutablePrioritizedList;
import com.eternalcode.core.libs.dev.rollczi.litecommands.priority.Prioritized;
import com.eternalcode.core.libs.dev.rollczi.litecommands.priority.PriorityLevel;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

class BeanCandidateContainer {
    private final Object lock = new Object();
    private final MutablePrioritizedList<BeanCandidate> candidates = new MutablePrioritizedList();
    private Function<BeanCandidate, PriorityLevel> priorityProvider = beanCandidate -> PriorityLevel.NORMAL;

    BeanCandidateContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCandidate(BeanCandidate candidate) {
        PriorityLevel priorityLevel = this.priorityProvider.apply(candidate);
        if (!priorityLevel.equals(candidate.getPriority())) {
            candidate = BeanCandidate.prioritized(candidate, priorityLevel);
        }
        Object object = this.lock;
        synchronized (object) {
            this.candidates.add((Prioritized)candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCandidate(BeanCandidate candidate) {
        Object object = this.lock;
        synchronized (object) {
            this.candidates.remove((Prioritized)candidate);
        }
    }

    void setPriorityProvider(Function<BeanCandidate, PriorityLevel> priorityProvider) {
        this.priorityProvider = priorityProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    BeanCandidate nextCandidate(Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            for (BeanCandidate candidate : this.candidates) {
                if (!candidate.isCandidate(type)) continue;
                this.candidates.remove((Prioritized)candidate);
                return candidate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    BeanCandidate nextCandidate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.candidates.isEmpty()) {
                return null;
            }
            BeanCandidate candidate = (BeanCandidate)this.candidates.first();
            this.candidates.remove((Prioritized)candidate);
            return candidate;
        }
    }
}

