/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp.command.permission;

import com.eternalcode.core.configuration.implementation.PluginConfiguration;
import com.eternalcode.core.feature.warp.Warp;
import com.eternalcode.core.feature.warp.WarpService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

@Command(name="warp-permission add")
@Permission(value={"eternalcore.warp.changepermissions"})
public class WarpAddPermissionCommand {
    private final PluginConfiguration config;
    private final WarpService warpService;
    private final NoticeService noticeService;

    @Inject
    public WarpAddPermissionCommand(PluginConfiguration config, WarpService warpService, NoticeService noticeService) {
        this.config = config;
        this.warpService = warpService;
        this.noticeService = noticeService;
    }

    @Execute
    void addPermission(@Sender Player player, @Arg Warp warp, String ... permissions) {
        UUID uniqueId = player.getUniqueId();
        if (permissions.length == 0) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).notice(translation -> translation.warp().noPermissionsProvided())).send();
            return;
        }
        List<String> currentPermissions = warp.getPermissions();
        List<String> newPermissions = Arrays.stream(permissions).filter(permission -> !currentPermissions.contains(permission)).toList();
        if (newPermissions.isEmpty()) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).placeholder("{WARP}", warp.getName())).placeholder("{PERMISSION}", String.join((CharSequence)this.config.format.separator, permissions))).notice(translation -> translation.warp().permissionAlreadyExist())).send();
            return;
        }
        this.warpService.addPermissions(warp.getName(), newPermissions.toArray(new String[0]));
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).placeholder("{WARP}", warp.getName())).notice(translation -> translation.warp().addPermissions())).send();
    }
}

