/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.ignore.IgnoreService;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;

@Command(name="tpa")
@Permission(value={"eternalcore.tpa"})
class TpaCommand {
    private final TeleportRequestService requestService;
    private final IgnoreService ignoreService;
    private final NoticeService noticeService;

    @Inject
    TpaCommand(TeleportRequestService requestService, IgnoreService ignoreService, NoticeService noticeService) {
        this.requestService = requestService;
        this.ignoreService = ignoreService;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Send teleport request to player"}, arguments={"<player>"})
    void execute(@Sender Player player, @Arg Player target) {
        if (player.equals((Object)target)) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaSelfMessage(), new Formatter[0]);
            return;
        }
        if (this.requestService.hasRequest(player.getUniqueId(), target.getUniqueId())) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaAlreadySentMessage(), new Formatter[0]);
            return;
        }
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaSentMessage())).placeholder("{PLAYER}", target.getName())).send();
        this.isIgnoring(target, player).thenAccept(isIgnoring -> {
            if (isIgnoring.booleanValue()) {
                ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaTargetIgnoresYou())).placeholder("{PLAYER}", target.getName())).send();
                return;
            }
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
            this.requestService.createRequest(player.getUniqueId(), target.getUniqueId());
        });
    }

    CompletableFuture<Boolean> isIgnoring(Player target, Player sender) {
        return this.ignoreService.isIgnored(target.getUniqueId(), sender.getUniqueId());
    }
}

