/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.speed;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;

@LiteArgument(type=Double.class, name="speed")
class SpeedArgument
extends AbstractViewerArgument<Double> {
    static final String KEY = "speed";
    private static final double MIN_SPEED = 0.0;
    private static final double MAX_SPEED = 10.0;
    private static final char DECIMAL_COMMA = ',';
    private static final char DECIMAL_DOT = '.';
    private static final double SUGGESTION_STEP = 0.5;

    @Inject
    SpeedArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<Double> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            String normalized = argument.replace(',', '.');
            double value = Double.parseDouble(normalized);
            if (value < 0.0 || value > 10.0) {
                return ParseResult.failure((Object)translation.speed().invalidSpeedRange());
            }
            return ParseResult.success((Object)value);
        }
        catch (NumberFormatException exception) {
            return ParseResult.failure((Object)translation.speed().invalidSpeedRange());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Double> argument, SuggestionContext context) {
        int maxIndex = (int)Math.round(20.0);
        return (SuggestionResult)IntStream.rangeClosed(0, maxIndex).mapToObj(i -> {
            double value = 0.0 + (double)i * 0.5;
            return value % 1.0 == 0.0 ? String.valueOf((int)value) : String.valueOf(value);
        }).collect(SuggestionResult.collector());
    }
}

