/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.itemedit;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.placeholder.Placeholders;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Command(name="itemflag")
@Permission(value={"eternalcore.itemflag"})
class ItemFlagCommand {
    private static final Placeholders<ItemFlag> ITEM_FLAG_PLACEHOLDER = Placeholders.of("{ITEM_FLAG}", Enum::name);
    private final NoticeService noticeService;

    @Inject
    ItemFlagCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Adds or removes item flag from item in hand"}, arguments={"<item-flag>"})
    void execute(@Sender Player player, @Arg ItemFlag flag) {
        ItemStack hand = player.getInventory().getItemInMainHand();
        ItemMeta meta = hand.getItemMeta();
        if (meta == null) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.argument().noItem(), new Formatter[0]);
            return;
        }
        Formatter formatter = ITEM_FLAG_PLACEHOLDER.toFormatter(flag);
        if (meta.hasItemFlag(flag)) {
            meta.removeItemFlags(new ItemFlag[]{flag});
            hand.setItemMeta(meta);
            this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().itemFlagRemovedMessage(), new Formatter[]{formatter});
            return;
        }
        meta.addItemFlags(new ItemFlag[]{flag});
        hand.setItemMeta(meta);
        this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().itemFlagAddedMessage(), new Formatter[]{formatter});
    }

    @Execute(name="clear")
    @DescriptionDocs(description={"Clears all item flags from item in hand"})
    void clear(@Sender Player player) {
        ItemStack hand = player.getInventory().getItemInMainHand();
        ItemMeta meta = hand.getItemMeta();
        if (meta == null) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.argument().noItem(), new Formatter[0]);
            return;
        }
        meta.removeItemFlags(ItemFlag.values());
        hand.setItemMeta(meta);
        this.noticeService.player(player.getUniqueId(), translation -> translation.itemEdit().itemFlagClearedMessage(), new Formatter[0]);
    }
}

