/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.deathmessage;

import com.eternalcode.core.feature.deathmessage.DeathContext;
import com.eternalcode.core.injector.annotations.component.Service;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;

@Service
public class DeathCauseResolver {
    public DeathContext resolve(Player victim, EntityDamageEvent damageEvent) {
        if (damageEvent == null) {
            return new DeathContext(victim, null, null, null, DeathContext.DeathType.UNKNOWN);
        }
        EntityDamageEvent.DamageCause cause = damageEvent.getCause();
        if (damageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityDamage = (EntityDamageByEntityEvent)damageEvent;
            Player killer = this.resolvePlayerKiller(entityDamage.getDamager());
            if (killer != null && killer.isValid() && !killer.equals((Object)victim)) {
                return new DeathContext(victim, killer, entityDamage.getDamager(), cause, DeathContext.DeathType.PLAYER_KILL);
            }
            if (entityDamage.getDamager() instanceof LivingEntity) {
                return new DeathContext(victim, null, entityDamage.getDamager(), cause, DeathContext.DeathType.ENTITY_KILL);
            }
        }
        return new DeathContext(victim, null, null, cause, DeathContext.DeathType.ENVIRONMENT);
    }

    private Player resolvePlayerKiller(Entity damager) {
        TNTPrimed tnt;
        Entity source;
        Projectile projectile;
        ProjectileSource shooter;
        if (damager instanceof Player) {
            Player player = (Player)damager;
            return player;
        }
        if (damager instanceof Projectile && (shooter = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
            Player player = (Player)shooter;
            return player;
        }
        if (damager instanceof TNTPrimed && (source = (tnt = (TNTPrimed)damager).getSource()) instanceof Player) {
            Player player = (Player)source;
            return player;
        }
        return null;
    }
}

