/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.chat;

import com.eternalcode.core.feature.chat.ChatSettings;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class ChatConfig
extends OkaeriConfig
implements ChatSettings {
    @Comment(value={"# Custom message for unknown command"})
    public boolean replaceStandardHelpMessage = false;
    @Comment(value={"# Chat delay to send next message in chat"})
    public Duration chatDelay = Duration.ofSeconds(5L);
    @Comment(value={"# Chat cooldowns per permission group", "# Configure how long players must wait between messages based on their permissions", "# ", "# Permission format: 'permission' -> cooldown", "# Players with higher permissions will get the lowest cooldown they qualify for", "# ", "# Default permissions:", "# - eternalcore.chat.cooldown.default: Basic players (3s)", "# - eternalcore.chat.cooldown.vip: VIP players (2s)", "# - eternalcore.chat.cooldown.premium: Premium players (1s)", "# - eternalcore.chat.cooldown.bypass: Administrators (0s)", "# ", "# You can add custom permission groups and limits as needed", "# Example: 'eternalcore.chat.cooldown.admin' -> 0s"})
    public Map<String, Duration> chatCooldowns = new LinkedHashMap<String, Duration>(){
        {
            this.put("eternalcore.chat.cooldown.default", Duration.ofSeconds(3L));
            this.put("eternalcore.chat.cooldown.vip", Duration.ofSeconds(2L));
            this.put("eternalcore.chat.cooldown.premium", Duration.ofSeconds(1L));
            this.put("eternalcore.chat.cooldown.bypass", Duration.ZERO);
        }
    };
    @Comment(value={"# Number of lines that will be cleared when using the /chat clear command"})
    public int linesToClear = 256;
    @Comment(value={"# Chat should be enabled?"})
    public boolean chatEnabled = true;

    @Override
    @Generated
    public boolean replaceStandardHelpMessage() {
        return this.replaceStandardHelpMessage;
    }

    @Override
    @Generated
    public Duration chatDelay() {
        return this.chatDelay;
    }

    @Override
    @Generated
    public Map<String, Duration> chatCooldowns() {
        return this.chatCooldowns;
    }

    @Override
    @Generated
    public int linesToClear() {
        return this.linesToClear;
    }

    @Override
    @Generated
    public boolean chatEnabled() {
        return this.chatEnabled;
    }

    @Generated
    public ChatConfig replaceStandardHelpMessage(boolean replaceStandardHelpMessage) {
        this.replaceStandardHelpMessage = replaceStandardHelpMessage;
        return this;
    }

    @Override
    @Generated
    public ChatConfig chatDelay(Duration chatDelay) {
        this.chatDelay = chatDelay;
        return this;
    }

    @Generated
    public ChatConfig chatCooldowns(Map<String, Duration> chatCooldowns) {
        this.chatCooldowns = chatCooldowns;
        return this;
    }

    @Override
    @Generated
    public ChatConfig linesToClear(int linesToClear) {
        this.linesToClear = linesToClear;
        return this;
    }

    @Override
    @Generated
    public ChatConfig chatEnabled(boolean chatEnabled) {
        this.chatEnabled = chatEnabled;
        return this;
    }
}

