/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.argument;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

@LiteArgument(type=Material.class)
public class MaterialArgument
extends AbstractViewerArgument<Material> {
    private static final SuggestionResult CACHED_SUGGESTIONS = (SuggestionResult)Arrays.stream(Material.values()).map(Enum::name).map(String::toLowerCase).collect(SuggestionResult.collector());

    @Inject
    MaterialArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<Material> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        Material material = Material.matchMaterial((String)argument);
        if (material == null) {
            return ParseResult.failure((Object)translation.argument().noMaterial());
        }
        return ParseResult.success((Object)material);
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Material> argument, SuggestionContext context) {
        return CACHED_SUGGESTIONS;
    }
}

