/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp.inventory;

import com.eternalcode.core.configuration.AbstractConfigurationFile;
import com.eternalcode.core.configuration.contextual.ConfigItem;
import com.eternalcode.core.feature.warp.WarpInventoryItem;
import com.eternalcode.core.injector.annotations.component.ConfigurationFile;
import com.eternalcode.core.libs.eu.okaeri.configs.OkaeriConfig;
import com.eternalcode.core.libs.eu.okaeri.configs.annotation.Comment;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Material;

@ConfigurationFile
public class WarpInventoryConfig
extends AbstractConfigurationFile {
    @Comment(value={"# Warp inventory configuration", "# This file contains the GUI layout and item definitions for the warp inventory", "# Text content (titles, names, lore) should be configured in language files"})
    public DisplaySection display = new DisplaySection();
    @Comment(value={"# Border configuration for the warp inventory"})
    public BorderSection border = new BorderSection();
    @Comment(value={"# Decoration items that can be placed in the inventory"})
    public DecorationItemsSection decorationItems = new DecorationItemsSection();
    @Comment(value={"# Warp items configuration - maps warp names to their inventory representation"})
    public Map<String, WarpInventoryItem> items = new HashMap<String, WarpInventoryItem>();

    @Override
    public File getConfigFile(File dataFolder) {
        return new File(dataFolder, "warp-inventory.yml");
    }

    @Generated
    public DisplaySection display() {
        return this.display;
    }

    @Generated
    public BorderSection border() {
        return this.border;
    }

    @Generated
    public DecorationItemsSection decorationItems() {
        return this.decorationItems;
    }

    @Generated
    public Map<String, WarpInventoryItem> items() {
        return this.items;
    }

    public static class DisplaySection
    extends OkaeriConfig {
        @Comment(value={"# Title of the warp inventory GUI"})
        public String title = "<dark_gray>\u00bb <green>Available warps:";

        @Generated
        public String title() {
            return this.title;
        }
    }

    public static class BorderSection
    extends OkaeriConfig {
        @Comment(value={"# Changes of border section may affect the appearance of the GUI inventory, after changes adjust slots of existing items."})
        public boolean enabled = true;
        @Comment(value={"# Material for border items"})
        public Material material = Material.GRAY_STAINED_GLASS_PANE;
        @Comment(value={"# How to fill the border"})
        public FillType fillType = FillType.BORDER;
        @Comment(value={"# Display name for border items (empty for no name)"})
        public String name = "";
        @Comment(value={"# Lore lines for border items"})
        public List<String> lore = Collections.emptyList();

        @Generated
        public boolean enabled() {
            return this.enabled;
        }

        @Generated
        public Material material() {
            return this.material;
        }

        @Generated
        public FillType fillType() {
            return this.fillType;
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public List<String> lore() {
            return this.lore;
        }
    }

    public static class DecorationItemsSection
    extends OkaeriConfig {
        @Comment(value={"# List of decoration items to display in the inventory"})
        public List<ConfigItem> items = List.of();

        @Generated
        public List<ConfigItem> items() {
            return this.items;
        }
    }

    public static enum FillType {
        BORDER,
        ALL,
        TOP,
        BOTTOM;

    }
}

