/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.vanish.controller;

import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.TabCompleteEvent;

@Controller
class TabCompleteController
implements Listener {
    private final VanishService vanishService;

    @Inject
    TabCompleteController(VanishService vanishService) {
        this.vanishService = vanishService;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onTabComplete(TabCompleteEvent event) {
        CommandSender commandSender = event.getSender();
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        if (player.hasPermission("eternalcore.vanish.see")) {
            return;
        }
        event.getCompletions().removeAll(this.vanishService.getVanishedPlayerNames());
    }
}

