/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.time;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.scheduler.MinecraftScheduler;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.World;

@Command(name="night")
@Permission(value={"eternalcore.night"})
class NightCommand {
    private final NoticeService noticeService;
    private final MinecraftScheduler scheduler;

    @Inject
    NightCommand(NoticeService noticeService, MinecraftScheduler scheduler) {
        this.noticeService = noticeService;
        this.scheduler = scheduler;
    }

    @Execute
    @DescriptionDocs(description={"Sets time to night in current world"})
    void night(@Sender Viewer viewer, @Context World world) {
        this.setNight(viewer, world);
    }

    @Execute
    @DescriptionDocs(description={"Sets time to night in specified world"}, arguments={"<world>"})
    void nightWorld(@Sender Viewer viewer, @Arg World world) {
        this.setNight(viewer, world);
    }

    private void setNight(Viewer viewer, World world) {
        this.scheduler.run(() -> world.setTime(13700L));
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().viewer(viewer)).placeholder("{WORLD}", world.getName())).notice(translation -> translation.timeAndWeather().timeSetNight())).send();
    }
}

