/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.teleportrequest.TeleportRequestService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.List;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Command(name="tpadeny", aliases={"tpdeny"})
@Permission(value={"eternalcore.tpadeny"})
class TpaDenyCommand {
    private final TeleportRequestService requestService;
    private final NoticeService noticeService;
    private final Server server;

    @Inject
    TpaDenyCommand(TeleportRequestService requestService, NoticeService noticeService, Server server) {
        this.requestService = requestService;
        this.noticeService = noticeService;
        this.server = server;
    }

    @Execute
    @DescriptionDocs(description={"Deny teleport request"}, arguments={"<player>"})
    void executeTarget(@Sender Player player, @Arg(value="requester") Player target) {
        this.requestService.removeRequest(target.getUniqueId());
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(player.getUniqueId())).notice(translation -> translation.tpa().tpaDenyDoneMessage())).placeholder("{PLAYER}", target.getName())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(target.getUniqueId())).notice(translation -> translation.tpa().tpaDenyReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
    }

    @Execute(name="-all", aliases={"*"})
    @DescriptionDocs(description={"Deny all teleport requests"})
    void executeAll(@Sender Player player) {
        List<UUID> requests = this.requestService.findRequests(player.getUniqueId());
        if (requests.isEmpty()) {
            this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaDenyNoRequestMessage(), new Formatter[0]);
            return;
        }
        for (UUID uniqueId : requests) {
            Player requester = this.server.getPlayer(uniqueId);
            this.requestService.removeRequest(uniqueId);
            if (requester == null) continue;
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uniqueId)).notice(translation -> translation.tpa().tpaDenyReceivedMessage())).placeholder("{PLAYER}", player.getName())).send();
        }
        this.noticeService.player(player.getUniqueId(), translation -> translation.tpa().tpaDenyAllDenied(), new Formatter[0]);
    }
}

