/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.randomteleport;

import com.eternalcode.core.event.EventCaller;
import com.eternalcode.core.feature.randomteleport.RandomTeleportRadius;
import com.eternalcode.core.feature.randomteleport.RandomTeleportResolveWorldUtil;
import com.eternalcode.core.feature.randomteleport.RandomTeleportResult;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSafeLocationService;
import com.eternalcode.core.feature.randomteleport.RandomTeleportService;
import com.eternalcode.core.feature.randomteleport.RandomTeleportSettings;
import com.eternalcode.core.feature.randomteleport.RandomTeleportType;
import com.eternalcode.core.feature.randomteleport.event.PreRandomTeleportEvent;
import com.eternalcode.core.feature.randomteleport.event.RandomTeleportEvent;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@Service
class RandomTeleportServiceImpl
implements RandomTeleportService {
    private final RandomTeleportSettings randomTeleportSettings;
    private final RandomTeleportSafeLocationService safeLocationService;
    private final EventCaller eventCaller;

    @Inject
    RandomTeleportServiceImpl(RandomTeleportSettings randomTeleportSettings, RandomTeleportSafeLocationService safeLocationService, EventCaller eventCaller) {
        this.randomTeleportSettings = randomTeleportSettings;
        this.safeLocationService = safeLocationService;
        this.eventCaller = eventCaller;
    }

    @Override
    public CompletableFuture<RandomTeleportResult> teleport(Player player) {
        World world = RandomTeleportResolveWorldUtil.resolveWorld(player, this.randomTeleportSettings);
        return this.teleport(player, world);
    }

    @Override
    public CompletableFuture<RandomTeleportResult> teleport(Player player, World world) {
        PreRandomTeleportEvent preRandomTeleportEvent = this.eventCaller.callEvent(new PreRandomTeleportEvent(player));
        if (preRandomTeleportEvent.isCancelled()) {
            return CompletableFuture.completedFuture(new RandomTeleportResult(false, player.getLocation()));
        }
        return this.getSafeRandomLocation(world, this.randomTeleportSettings.teleportAttempts()).thenCompose(location -> PaperLib.teleportAsync((Entity)player, (Location)location).thenApply(success -> {
            RandomTeleportResult teleportResult = new RandomTeleportResult((boolean)success, (Location)location);
            RandomTeleportEvent event = new RandomTeleportEvent(player, (Location)location);
            this.eventCaller.callEvent(event);
            return teleportResult;
        }));
    }

    @Override
    public CompletableFuture<Map<Player, RandomTeleportResult>> teleport(Collection<Player> players) {
        if (players.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        Player firstPlayer = players.iterator().next();
        World world = RandomTeleportResolveWorldUtil.resolveWorld(firstPlayer, this.randomTeleportSettings);
        return this.teleport(players, world);
    }

    @Override
    public CompletableFuture<Map<Player, RandomTeleportResult>> teleport(Collection<Player> players, World world) {
        if (players.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        return this.getSafeRandomLocation(world, this.randomTeleportSettings.teleportAttempts()).thenCompose(location -> this.teleport(players, (Location)location));
    }

    @Override
    public CompletableFuture<Map<Player, RandomTeleportResult>> teleport(Collection<Player> players, Location location) {
        if (players.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        List<CompletableFuture> futures = players.stream().map(player -> {
            PreRandomTeleportEvent preRandomTeleportEvent = this.eventCaller.callEvent(new PreRandomTeleportEvent((Player)player));
            if (preRandomTeleportEvent.isCancelled()) {
                return CompletableFuture.completedFuture(Map.entry(player, new RandomTeleportResult(false, player.getLocation())));
            }
            return PaperLib.teleportAsync((Entity)player, (Location)location).thenApply(success -> {
                RandomTeleportResult teleportResult = new RandomTeleportResult((boolean)success, location);
                this.eventCaller.callEvent(new RandomTeleportEvent((Player)player, location));
                return Map.entry(player, teleportResult);
            });
        }).toList();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Override
    public CompletableFuture<Location> getSafeRandomLocation(World world, int attemptCount) {
        RandomTeleportRadius radius = switch (this.randomTeleportSettings.radiusType()) {
            default -> throw new MatchException(null, null);
            case RandomTeleportType.STATIC_RADIUS -> this.randomTeleportSettings.radius();
            case RandomTeleportType.WORLD_BORDER_RADIUS -> this.getWorldBorderRadius(world);
        };
        return this.safeLocationService.getSafeRandomLocation(world, radius, attemptCount);
    }

    @Override
    public CompletableFuture<Location> getSafeRandomLocation(World world, int radius, int attemptCount) {
        return this.safeLocationService.getSafeRandomLocation(world, RandomTeleportRadius.of(radius), attemptCount);
    }

    @Override
    public CompletableFuture<Location> getSafeRandomLocation(World world, RandomTeleportRadius radius, int attemptCount) {
        return this.safeLocationService.getSafeRandomLocation(world, radius, attemptCount);
    }

    @Override
    public CompletableFuture<Location> getSafeRandomLocationInWorldBorder(World world, int attemptCount) {
        return this.getSafeRandomLocation(world, this.getWorldBorderRadius(world), attemptCount);
    }

    private RandomTeleportRadius getWorldBorderRadius(World world) {
        WorldBorder worldBorder = world.getWorldBorder();
        int borderRadius = (int)(worldBorder.getSize() / 2.0);
        return RandomTeleportRadius.of(-borderRadius, borderRadius, -borderRadius, borderRadius);
    }
}

