/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.onlineplayers;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.configuration.implementation.PluginConfiguration;
import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Server;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

@Command(name="list")
@Permission(value={"eternalcore.list"})
class OnlinePlayersListCommand {
    private final NoticeService noticeService;
    private final PluginConfiguration config;
    private final VanishService vanishService;
    private final Server server;

    @Inject
    OnlinePlayersListCommand(PluginConfiguration config, NoticeService noticeService, VanishService vanishService, Server server) {
        this.config = config;
        this.noticeService = noticeService;
        this.vanishService = vanishService;
        this.server = server;
    }

    @Execute
    @DescriptionDocs(description={"Shows online players list"})
    void execute(@Sender Viewer viewer) {
        List<Player> online = this.server.getOnlinePlayers().stream().filter(player -> !this.vanishService.isVanished((Player)player)).toList();
        String onlineCount = String.valueOf(online.size());
        String players = online.stream().map(HumanEntity::getName).collect(Collectors.joining(this.config.format.separator));
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.online().onlinePlayersList())).placeholder("{ONLINE}", onlineCount)).placeholder("{PLAYERS}", players)).viewer(viewer)).send();
    }
}

