/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.onlineplayers;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.vanish.VanishService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Command(name="online")
@Permission(value={"eternalcore.online"})
class OnlinePlayerCountCommand {
    private final NoticeService noticeService;
    private final VanishService vanishService;
    private final Server server;

    @Inject
    OnlinePlayerCountCommand(NoticeService noticeService, VanishService vanishService, Server server) {
        this.noticeService = noticeService;
        this.vanishService = vanishService;
        this.server = server;
    }

    @Execute
    @DescriptionDocs(description={"Shows online players count"})
    void execute(@Sender Viewer viewer) {
        long visiblePlayerCount = this.server.getOnlinePlayers().stream().filter(player -> !this.vanishService.isVanished((Player)player)).count();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.online().onlinePlayersCount())).viewer(viewer)).placeholder("{ONLINE}", String.valueOf(visiblePlayerCount))).send();
    }
}

