/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.msg;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.msg.MsgService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.RootCommand;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.join.Join;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import java.util.UUID;
import org.bukkit.entity.Player;

@RootCommand
class MsgCommands {
    private final MsgService msgService;
    private final NoticeService noticeService;

    @Inject
    MsgCommands(MsgService msgService, NoticeService noticeService) {
        this.msgService = msgService;
        this.noticeService = noticeService;
    }

    @Execute(name="msg", aliases={"message", "m", "whisper", "tell", "t"})
    @Permission(value={"eternalcore.msg"})
    @DescriptionDocs(description={"Send private message to specified player"}, arguments={"<player> <message>"})
    void execute(@Sender Player sender, @Arg Player target, @Join String message) {
        this.msgService.sendMessage(sender, target, message);
    }

    @Execute(name="reply", aliases={"r"})
    @Permission(value={"eternalcore.reply"})
    @DescriptionDocs(description={"Reply to last private message"}, arguments={"<message>"})
    void execute(@Sender Player sender, @Join String message) {
        this.msgService.reply(sender, message);
    }

    @Execute(name="socialspy", aliases={"spy"})
    @Permission(value={"eternalcore.spy"})
    @DescriptionDocs(description={"Enable or disable social spy"})
    void socialSpy(@Sender Player player) {
        UUID uuid = player.getUniqueId();
        if (this.msgService.isSpy(uuid)) {
            this.msgService.disableSpy(uuid);
            this.notifyAboutSocialSpy(uuid);
            return;
        }
        this.msgService.enableSpy(uuid);
        this.notifyAboutSocialSpy(uuid);
    }

    private void notifyAboutSocialSpy(UUID uuid) {
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().player(uuid)).notice(translation -> this.msgService.isSpy(uuid) ? translation.msg().socialSpyEnable() : translation.msg().socialSpyDisable())).placeholder("{STATE}", translation -> this.msgService.isSpy(uuid) ? translation.format().enable() : translation.format().disable())).send();
    }
}

