/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.itemedit;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.List;
import org.bukkit.command.CommandSender;

@LiteArgument(type=int.class, name="item-lore")
class ItemLoreArgument
extends AbstractViewerArgument<Integer> {
    static final String KEY = "item-lore";
    private static final List<Integer> suggestions = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6));

    @Inject
    public ItemLoreArgument(TranslationManager translationManager) {
        super(translationManager);
    }

    @Override
    public ParseResult<Integer> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        try {
            int value = Integer.parseInt(argument);
            if (value < 1) {
                return ParseResult.failure((Object)translation.argument().numberBiggerThanOrEqualZero());
            }
            return ParseResult.success((Object)(value - 1));
        }
        catch (NumberFormatException exception) {
            return ParseResult.failure((Object)translation.argument().numberBiggerThanOrEqualZero());
        }
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Integer> argument, SuggestionContext context) {
        return (SuggestionResult)suggestions.stream().map(String::valueOf).collect(SuggestionResult.collector());
    }
}

