/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.database;

import com.eternalcode.core.database.DatabaseConnectionDriverConstant;
import com.eternalcode.core.database.DatabaseDriverType;
import com.eternalcode.core.database.DatabaseException;
import com.eternalcode.core.database.DatabaseSettings;
import com.eternalcode.core.libs.com.j256.ormlite.dao.Dao;
import com.eternalcode.core.libs.com.j256.ormlite.dao.DaoManager;
import com.eternalcode.core.libs.com.j256.ormlite.jdbc.DataSourceConnectionSource;
import com.eternalcode.core.libs.com.j256.ormlite.support.ConnectionSource;
import com.eternalcode.core.libs.com.zaxxer.hikari.HikariDataSource;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DatabaseManager {
    private final Logger logger;
    private final File dataFolder;
    private final DatabaseSettings settings;
    private final Map<Class<?>, Dao<?, ?>> cachedDao = new ConcurrentHashMap();
    private HikariDataSource dataSource;
    private ConnectionSource connectionSource;

    public DatabaseManager(Logger logger, File dataFolder, DatabaseSettings settings) {
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.settings = settings;
    }

    public void connect() {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.dataSource = new HikariDataSource();
            this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)"true");
            this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            this.dataSource.setMaximumPoolSize(this.settings.poolSize());
            this.dataSource.setConnectionTimeout((long)this.settings.timeout());
            this.dataSource.setUsername(this.settings.username());
            this.dataSource.setPassword(this.settings.password());
            DatabaseDriverType type = this.settings.databaseType();
            this.dataSource.setDriverClassName(type.getDriver());
            String jdbcUrl = switch (type) {
                default -> throw new MatchException(null, null);
                case DatabaseDriverType.H2, DatabaseDriverType.SQLITE -> type.formatUrl(this.dataFolder);
                case DatabaseDriverType.POSTGRESQL -> type.formatUrl(this.settings.hostname(), this.settings.port(), this.settings.database(), DatabaseConnectionDriverConstant.sslParamForPostgreSQL(this.settings.ssl()));
                case DatabaseDriverType.MYSQL -> type.formatUrl(this.settings.hostname(), this.settings.port(), this.settings.database(), DatabaseConnectionDriverConstant.sslParamForMySQL(this.settings.ssl()));
                case DatabaseDriverType.MARIADB -> type.formatUrl(this.settings.hostname(), this.settings.port(), this.settings.database(), String.valueOf(this.settings.ssl()));
            };
            this.dataSource.setJdbcUrl(jdbcUrl);
            this.connectionSource = new DataSourceConnectionSource((DataSource)this.dataSource, jdbcUrl);
            this.logger.info("Loaded database " + String.valueOf((Object)type) + " in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms");
        }
        catch (Exception exception) {
            throw new DatabaseException("Failed to connect to the database", exception);
        }
    }

    public void close() {
        try {
            this.dataSource.close();
            this.connectionSource.close();
        }
        catch (Exception exception) {
            this.logger.severe("Failed to close database connection: " + exception.getMessage());
        }
    }

    public <T, ID> Dao<T, ID> getDao(Class<T> type) {
        return this.cachedDao.computeIfAbsent(type, clazz -> {
            try {
                return DaoManager.createDao((ConnectionSource)this.connectionSource, (Class)clazz);
            }
            catch (SQLException e) {
                throw new DatabaseException("Failed to create DAO for " + clazz.getName(), e);
            }
        });
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource;
    }
}

