/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.database;

public enum DatabaseDriverType {
    MYSQL("com.mysql.cj.jdbc.Driver", "jdbc:mysql://%s:%s/%s?sslMode=%s"),
    MARIADB("com.eternalcode.core.libs.org.mariadb.jdbc.Driver", "jdbc:mariadb://%s:%s/%s?sslMode=%s"),
    POSTGRESQL("com.eternalcode.core.libs.org.postgresql.Driver", "jdbc:postgresql://%s:%s/%s?sslmode=%s"),
    H2("org.h2.Driver", "jdbc:h2:./%s/database"),
    SQLITE("org.sqlite.JDBC", "jdbc:sqlite:%s/database.db");

    private final String driver;
    private final String urlFormat;

    private DatabaseDriverType(String driver, String urlFormat) {
        this.driver = driver;
        this.urlFormat = urlFormat;
    }

    public String getDriver() {
        return this.driver;
    }

    public String formatUrl(Object ... args) {
        return String.format(this.urlFormat, args);
    }
}

