/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

@Deprecated(since="2.0")
class CdnConfigMigrator {
    private static final List<String> MAPS_TO_MIGRATE = List.of("argument.gameModeAliases", "gameModeShortCuts", "commands", "homes.maxHomes", "autoMessage.messages", "warp.warpInventory.items", "event.deathMessageByDamageCause");
    private final Yaml yaml;

    CdnConfigMigrator(Yaml yaml) {
        this.yaml = yaml;
    }

    void runMigrations(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            String migratedLists = CdnConfigMigrator.migrateListWithObjects(Files.readAllLines(file.toPath()));
            String migratedMaps = this.migrateEmptyMaps(migratedLists);
            Files.writeString(file.toPath(), (CharSequence)migratedMaps, new OpenOption[0]);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static String migrateListWithObjects(List<String> lines) {
        ArrayList<Object> fixedLines = new ArrayList<Object>();
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            String trimmed = line.trim();
            if (trimmed.equals("- :") && i + 1 < lines.size()) {
                String currentIndent = line.substring(0, line.indexOf("-"));
                String nextLine = lines.get(i + 1);
                String merged = currentIndent + "- " + nextLine.stripLeading();
                fixedLines.add(merged);
                i += 2;
                continue;
            }
            fixedLines.add(line);
            ++i;
        }
        return String.join((CharSequence)System.lineSeparator(), fixedLines);
    }

    private String migrateEmptyMaps(String migrated) {
        Map config = (Map)this.yaml.load(migrated);
        if (config == null) {
            return migrated;
        }
        for (String key : MAPS_TO_MIGRATE) {
            this.migrateEmptyMap(config, key);
        }
        return this.yaml.dump((Object)config);
    }

    private void migrateEmptyMap(Map<String, Object> config, String fullKey) {
        Object value;
        String[] keyParts = fullKey.split("\\.");
        Map currentMap = config;
        for (int i = 0; i < keyParts.length - 1; ++i) {
            value = currentMap.get(keyParts[i]);
            if (!(value instanceof Map)) {
                return;
            }
            currentMap = (Map)value;
        }
        String finalKey = keyParts[keyParts.length - 1];
        value = currentMap.get(finalKey);
        if (value instanceof List && ((List)value).isEmpty()) {
            currentMap.put(finalKey, new LinkedHashMap());
        }
    }
}

