/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.annotations.scan.command;

import com.eternalcode.annotations.scan.EternalScanRecord;
import com.eternalcode.annotations.scan.EternalScanResolver;
import com.eternalcode.annotations.scan.command.CommandResult;
import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.RootCommand;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permissions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public class CommandScanResolver
implements EternalScanResolver<CommandResult> {
    @Override
    public List<CommandResult> resolve(EternalScanRecord record) {
        Class<?> type = record.clazz();
        Command annotation = type.getAnnotation(Command.class);
        if (annotation != null) {
            return this.handleCommand(record, annotation);
        }
        RootCommand rootRoute = type.getAnnotation(RootCommand.class);
        if (rootRoute != null) {
            return this.handleRootRoute(record, rootRoute);
        }
        return List.of();
    }

    private List<CommandResult> handleCommand(EternalScanRecord record, Command command) {
        ArrayList<CommandResult> results = new ArrayList<CommandResult>();
        for (Method method : record.methods()) {
            Execute execute = method.getAnnotation(Execute.class);
            if (execute == null) continue;
            String name = command.name() + " " + execute.name();
            List<String> aliases = Arrays.stream(execute.aliases()).map(alias -> command.name() + ", " + alias).toList();
            results.add(this.handleExecutor(record, method, name, aliases));
        }
        return CommandScanResolver.removeDuplicates(results);
    }

    private List<CommandResult> handleRootRoute(EternalScanRecord record, RootCommand rootCommand) {
        ArrayList<CommandResult> results = new ArrayList<CommandResult>();
        for (Method method : record.methods()) {
            Execute execute = method.getAnnotation(Execute.class);
            if (execute == null) continue;
            String name = execute.name();
            List<String> aliases = Arrays.asList(execute.aliases());
            results.add(this.handleExecutor(record, method, name, aliases));
        }
        return CommandScanResolver.removeDuplicates(results);
    }

    private CommandResult handleExecutor(EternalScanRecord record, Method method, String name, List<String> aliases) {
        Class<?> clazz = record.clazz();
        HashSet permissions = new HashSet();
        permissions.addAll(this.scan(Permission.class, clazz, method, Permission::value));
        permissions.addAll(this.scan(Permissions.class, clazz, method, permissionsAnnotation -> {
            ArrayList<String> permissionsList = new ArrayList<String>();
            for (Permission permission : permissionsAnnotation.value()) {
                permissionsList.addAll(Arrays.asList(permission.value()));
            }
            return permissionsList.toArray(new String[0]);
        }));
        List<String> description = this.scan(DescriptionDocs.class, Object.class, method, DescriptionDocs::description);
        List<String> arguments = this.scan(DescriptionDocs.class, Object.class, method, DescriptionDocs::arguments);
        return new CommandResult(name, aliases, List.copyOf(permissions), description, arguments);
    }

    private <A extends Annotation, R> List<R> scan(Class<A> annotationClass, Class<?> type, Method method, Function<A, R[]> resolver) {
        A methodAnnotation;
        ArrayList<R> results = new ArrayList<R>();
        A annotation = type.getAnnotation(annotationClass);
        if (annotation != null) {
            results.addAll(List.of(resolver.apply(annotation)));
        }
        if ((methodAnnotation = method.getAnnotation(annotationClass)) != null) {
            results.addAll(List.of(resolver.apply(methodAnnotation)));
        }
        return results;
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        return new ArrayList<T>(new HashSet<T>(list));
    }
}

