/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.placeholder;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.placeholder.Placeholder;
import com.eternalcode.core.placeholder.PlaceholderRaw;
import com.eternalcode.core.placeholder.PlaceholderRegistry;
import com.eternalcode.core.viewer.Viewer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.entity.Player;

@Service
public class PlaceholderBukkitRegistryImpl
implements PlaceholderRegistry {
    private final Server server;
    private final Set<Placeholder> replacerPlayers = new HashSet<Placeholder>();
    private final Map<String, PlaceholderRaw> rawPlaceholders = new HashMap<String, PlaceholderRaw>();

    @Inject
    public PlaceholderBukkitRegistryImpl(Server server) {
        this.server = server;
    }

    @Override
    public void register(Placeholder stack) {
        this.replacerPlayers.add(stack);
        if (stack instanceof PlaceholderRaw) {
            PlaceholderRaw raw = (PlaceholderRaw)stack;
            this.rawPlaceholders.put(raw.getRawTarget(), raw);
        }
    }

    @Override
    public String format(String text, Viewer target) {
        Player playerTarget;
        if (!target.isConsole() && (playerTarget = this.server.getPlayer(target.getUniqueId())) != null) {
            for (Placeholder replacer : this.replacerPlayers) {
                text = replacer.apply(text, playerTarget);
            }
        }
        return text;
    }

    @Override
    public Optional<PlaceholderRaw> getRawPlaceholder(String target) {
        return Optional.ofNullable(this.rawPlaceholders.get(target));
    }
}

