/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.relocation;

import com.eternalcode.core.loader.classloader.IsolatedClassLoader;
import com.eternalcode.core.loader.dependency.Dependency;
import com.eternalcode.core.loader.dependency.DependencyException;
import com.eternalcode.core.loader.dependency.DependencyLoadResult;
import com.eternalcode.core.loader.dependency.DependencyLoader;
import com.eternalcode.core.loader.relocation.Relocation;
import com.eternalcode.core.loader.relocation.RelocationCacheResolver;
import com.eternalcode.core.loader.repository.Repository;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelocationHandler
implements AutoCloseable {
    private static final List<Dependency> DEPENDENCIES = List.of(Dependency.of("org.ow2.asm", "asm", "9.7.1"), Dependency.of("org.ow2.asm", "asm-commons", "9.7.1"), Dependency.of("me.lucko", "jar-relocator", "1.7"));
    private static final String JAR_RELOCATOR_CLASS = "me.lucko.jarrelocator.JarRelocator";
    private static final String JAR_RELOCATOR_RUN_METHOD = "run";
    private final IsolatedClassLoader classLoader;
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;
    private final RelocationCacheResolver cacheResolver;

    private RelocationHandler(IsolatedClassLoader classLoader, Constructor<?> jarRelocatorConstructor, Method jarRelocatorRunMethod, RelocationCacheResolver cacheResolver) {
        this.classLoader = classLoader;
        this.jarRelocatorConstructor = jarRelocatorConstructor;
        this.jarRelocatorRunMethod = jarRelocatorRunMethod;
        this.cacheResolver = cacheResolver;
    }

    public Path relocateDependency(Repository localRepository, Path dependencyPath, Dependency dependency, List<Relocation> relocations) {
        if (relocations.isEmpty()) {
            return dependencyPath;
        }
        Path relocatedJar = dependency.toMavenJar(localRepository, "relocated").toPath();
        if (Files.exists(relocatedJar, new LinkOption[0]) && !this.cacheResolver.shouldForceRelocate(dependency, relocations)) {
            return relocatedJar;
        }
        return this.relocate(dependency, dependencyPath, relocatedJar, relocations);
    }

    private Path relocate(Dependency dependency, Path input, Path output, List<Relocation> relocations) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Relocation relocation : relocations) {
            mappings.put(relocation.pattern(), relocation.relocatedPattern());
        }
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(output);
            Files.createFile(output, new FileAttribute[0]);
            Object relocator = this.jarRelocatorConstructor.newInstance(input.toFile(), output.toFile(), mappings);
            this.jarRelocatorRunMethod.invoke(relocator, new Object[0]);
            this.cacheResolver.markAsRelocated(dependency, relocations);
            return output;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            throw new DependencyException("Failed to create JarRelocator instance", exception);
        }
    }

    public static RelocationHandler create(DependencyLoader dependencyLoader, RelocationCacheResolver cacheResolver) {
        DependencyLoadResult result = dependencyLoader.load(DEPENDENCIES, List.of());
        IsolatedClassLoader classLoader = result.loader();
        try {
            Class<?> jarRelocatorClass = classLoader.loadClass(JAR_RELOCATOR_CLASS);
            Constructor<?> jarRelocatorConstructor = jarRelocatorClass.getDeclaredConstructor(File.class, File.class, Map.class);
            jarRelocatorConstructor.setAccessible(true);
            Method jarRelocatorRunMethod = jarRelocatorClass.getDeclaredMethod(JAR_RELOCATOR_RUN_METHOD, new Class[0]);
            jarRelocatorRunMethod.setAccessible(true);
            return new RelocationHandler(classLoader, jarRelocatorConstructor, jarRelocatorRunMethod, cacheResolver);
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            throw new DependencyException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        this.classLoader.close();
    }
}

