/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.loader.classloader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import sun.misc.Unsafe;

abstract class URLClassLoaderAccessor {
    private final URLClassLoader classLoader;

    public static URLClassLoaderAccessor create(URLClassLoader classLoader) {
        if (ReflectionURLClassLoaderAccessor.isSupported()) {
            return new ReflectionURLClassLoaderAccessor(classLoader);
        }
        if (UnsafeURLClassLoaderAccessor.isSupported()) {
            return new UnsafeURLClassLoaderAccessor(classLoader);
        }
        return Noop.INSTANCE;
    }

    protected URLClassLoaderAccessor(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public abstract void addURL(URL var1);

    public void addJarToClasspath(Path file) {
        try {
            this.addURL(file.toUri().toURL());
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void throwError(Throwable cause) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("EternalCore is unable to inject into the plugin URLClassLoader.\nYou may be able to fix this problem by adding the following command-line argument directly after the 'java' command in your start script: \n'--add-opens java.base/java.lang=ALL-UNNAMED'", cause);
    }

    private static class ReflectionURLClassLoaderAccessor
    extends URLClassLoaderAccessor {
        private static final Method ADD_URL_METHOD;

        private static boolean isSupported() {
            return ADD_URL_METHOD != null;
        }

        ReflectionURLClassLoaderAccessor(URLClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public void addURL(URL url) {
            try {
                ADD_URL_METHOD.invoke((Object)this.classLoader, url);
            }
            catch (ReflectiveOperationException e) {
                URLClassLoaderAccessor.throwError(e);
            }
        }

        static {
            Method addUrlMethod;
            try {
                addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addUrlMethod.setAccessible(true);
            }
            catch (Exception e) {
                addUrlMethod = null;
            }
            ADD_URL_METHOD = addUrlMethod;
        }
    }

    private static class UnsafeURLClassLoaderAccessor
    extends URLClassLoaderAccessor {
        private static final Unsafe UNSAFE;
        private final Collection<URL> unopenedURLs;
        private final Collection<URL> pathURLs;

        private static boolean isSupported() {
            return UNSAFE != null;
        }

        UnsafeURLClassLoaderAccessor(URLClassLoader classLoader) {
            super(classLoader);
            Collection pathURLs;
            Collection unopenedURLs;
            try {
                Object ucp = UnsafeURLClassLoaderAccessor.fetchField(URLClassLoader.class, classLoader, "ucp");
                unopenedURLs = (Collection)UnsafeURLClassLoaderAccessor.fetchField(ucp.getClass(), ucp, "unopenedUrls");
                pathURLs = (Collection)UnsafeURLClassLoaderAccessor.fetchField(ucp.getClass(), ucp, "path");
            }
            catch (Throwable throwable) {
                unopenedURLs = null;
                pathURLs = null;
            }
            this.unopenedURLs = unopenedURLs;
            this.pathURLs = pathURLs;
        }

        private static Object fetchField(Class<?> clazz, Object object, String name) throws NoSuchFieldException {
            Field field = clazz.getDeclaredField(name);
            long offset = UNSAFE.objectFieldOffset(field);
            return UNSAFE.getObject(object, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addURL(URL url) {
            if (this.unopenedURLs == null || this.pathURLs == null) {
                URLClassLoaderAccessor.throwError(new NullPointerException("unopenedURLs or pathURLs"));
            }
            Collection<URL> collection = this.unopenedURLs;
            synchronized (collection) {
                this.unopenedURLs.add(url);
                this.pathURLs.add(url);
            }
        }

        static {
            Unsafe unsafe;
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
            }
            catch (Throwable throwable) {
                unsafe = null;
            }
            UNSAFE = unsafe;
        }
    }

    private static class Noop
    extends URLClassLoaderAccessor {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
            super(null);
        }

        @Override
        public void addURL(URL url) {
            URLClassLoaderAccessor.throwError(null);
        }
    }
}

