/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.injector.bean.processor;

import com.eternalcode.core.configuration.AbstractConfigurationFile;
import com.eternalcode.core.configuration.ConfigurationManager;
import com.eternalcode.core.injector.annotations.component.Task;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.injector.annotations.lite.LiteCommandEditor;
import com.eternalcode.core.injector.annotations.lite.LiteContextual;
import com.eternalcode.core.injector.annotations.lite.LiteHandler;
import com.eternalcode.core.injector.bean.processor.BeanProcessor;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.libs.dev.rollczi.litecommands.LiteCommandsBuilder;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.LiteCommandsAnnotations;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.RootCommand;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.ArgumentKey;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.resolver.ArgumentResolverBase;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.resolver.MultipleArgumentResolver;
import com.eternalcode.core.libs.dev.rollczi.litecommands.context.ContextProvider;
import com.eternalcode.core.libs.dev.rollczi.litecommands.editor.Editor;
import com.eternalcode.core.libs.dev.rollczi.litecommands.handler.result.ResultHandler;
import com.eternalcode.core.libs.dev.rollczi.litecommands.scope.Scope;
import com.eternalcode.core.publish.Publisher;
import com.eternalcode.core.publish.SubscriberUtil;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class BeanProcessorFactory {
    private BeanProcessorFactory() {
    }

    public static BeanProcessor defaultProcessors(Plugin plugin) {
        Server server = plugin.getServer();
        PluginManager pluginManager = server.getPluginManager();
        return new BeanProcessor().onProcess(Task.class, Runnable.class, (provider, runnable, task) -> {
            Scheduler scheduler = provider.getDependency(Scheduler.class);
            ChronoUnit unit = task.unit().toChronoUnit();
            Duration delay = Duration.of(task.delay(), unit);
            Duration period = Duration.of(task.period(), unit);
            if (period.isZero()) {
                scheduler.runLater(runnable, delay);
            } else {
                scheduler.timer(runnable, delay, period);
            }
        }).onProcess(Listener.class, (provider, listener, none) -> pluginManager.registerEvents(listener, plugin)).onProcess(Object.class, (provider, potentialSubscriber, none) -> {
            if (!SubscriberUtil.isSubscriber(potentialSubscriber.getClass())) {
                return;
            }
            Publisher publisher = provider.getDependency(Publisher.class);
            publisher.subscribe(potentialSubscriber);
        }).onProcess(AbstractConfigurationFile.class, (provider, config, configurationFile) -> {
            ConfigurationManager configurationManager = provider.getDependency(ConfigurationManager.class);
            configurationManager.load(config);
        }).onProcess(Command.class, Object.class, (provider, command, none) -> {
            LiteCommandsAnnotations commandsBuilder = provider.getDependency(LiteCommandsAnnotations.class);
            commandsBuilder.load(new Object[]{command});
        }).onProcess(RootCommand.class, Object.class, (provider, rootCommand, none) -> {
            LiteCommandsAnnotations commandsBuilder = provider.getDependency(LiteCommandsAnnotations.class);
            commandsBuilder.load(new Object[]{rootCommand});
        }).onProcess(LiteArgument.class, MultipleArgumentResolver.class, (provider, multilevelArgument, liteArgument) -> {
            LiteCommandsBuilder builder = provider.getDependency(LiteCommandsBuilder.class);
            builder.argument(liteArgument.type(), ArgumentKey.of((String)liteArgument.name()), (ArgumentResolverBase)multilevelArgument);
        }).onProcess(LiteHandler.class, ResultHandler.class, (provider, handler, liteHandler) -> {
            LiteCommandsBuilder builder = provider.getDependency(LiteCommandsBuilder.class);
            builder.result(liteHandler.value(), handler);
        }).onProcess(LiteContextual.class, ContextProvider.class, (provider, contextProvider, liteContextual) -> {
            LiteCommandsBuilder builder = provider.getDependency(LiteCommandsBuilder.class);
            builder.context(liteContextual.value(), contextProvider);
        }).onProcess(LiteCommandEditor.class, Editor.class, (provider, editor, liteCommandEditor) -> {
            LiteCommandsBuilder builder = provider.getDependency(LiteCommandsBuilder.class);
            Scope scope = Scope.global();
            if (liteCommandEditor.command() != Object.class) {
                scope = Scope.command(liteCommandEditor.command());
            }
            if (!liteCommandEditor.name().isEmpty()) {
                scope = Scope.command((String)liteCommandEditor.name());
            }
            builder.editor(scope, editor);
        });
    }
}

