/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleport.command;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.feature.teleport.TeleportService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.multification.shared.Formatter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.placeholder.Placeholders;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

@Command(name="teleport", aliases={"tp"})
@Permission(value={"eternalcore.teleport"})
class TeleportCommand {
    private static final Placeholders<TeleportContext> CONTEXT = Placeholders.builder().with("{PLAYER}", context -> context.player.getName()).with("{X}", context -> String.valueOf(context.location.getX())).with("{Y}", context -> String.valueOf(context.location.getY())).with("{Z}", context -> String.valueOf(context.location.getZ())).with("{WORLD}", context -> context.location.getWorld() != null ? context.location.getWorld().getName() : "null").build();
    private static final Placeholders<Player> OTHER_PLAYER = Placeholders.builder().with("{ARG-PLAYER}", Player::getName).build();
    private final NoticeService noticeService;
    private final TeleportService teleportService;

    @Inject
    TeleportCommand(NoticeService noticeService, TeleportService teleportService) {
        this.noticeService = noticeService;
        this.teleportService = teleportService;
    }

    @Execute
    @DescriptionDocs(description={"Teleport to specified player"}, arguments={"<player>"})
    void execute(@Sender Player sender, @Sender Viewer senderViewer, @Arg Player player) {
        this.teleportService.teleport(sender, player.getLocation());
        Formatter formatter = this.formatter(player, player.getLocation());
        this.noticeService.viewer(senderViewer, translation -> translation.teleport().teleportedToPlayer(), new Formatter[]{formatter});
    }

    @Execute
    @DescriptionDocs(description={"Teleport player to player"}, arguments={"<player> <target-player>"})
    void other(@Sender Viewer sender, @Arg Player player, @Arg Player target) {
        this.teleportService.teleport(player, target.getLocation());
        Formatter formatter = this.formatter(player, target.getLocation());
        Formatter otherFormatter = OTHER_PLAYER.toFormatter(target);
        this.noticeService.viewer(sender, translation -> translation.teleport().teleportedPlayerToPlayer(), new Formatter[]{formatter, otherFormatter});
    }

    @Execute
    @DescriptionDocs(description={"Teleport to specified location"}, arguments={"<x> <y> <z>"})
    void to(@Sender Player sender, @Arg Location location) {
        location.setWorld(sender.getWorld());
        this.teleportService.teleport(sender, location);
        Formatter formatter = this.formatter(sender, location);
        this.noticeService.player(sender.getUniqueId(), translation -> translation.teleport().teleportedToCoordinates(), new Formatter[]{formatter});
    }

    @Execute
    @DescriptionDocs(description={"Teleport to specified location and world"}, arguments={"<x> <y> <z> <world>"})
    void to(@Sender Player sender, @Arg Location location, @Arg World world) {
        location.setWorld(world);
        this.teleportService.teleport(sender, location);
        Formatter formatter = this.formatter(sender, location);
        this.noticeService.player(sender.getUniqueId(), translation -> translation.teleport().teleportedToCoordinates(), new Formatter[]{formatter});
    }

    @Execute
    @DescriptionDocs(description={"Teleport player to specified location and world"}, arguments={"<player> <x> <y> <z>"})
    void to(@Sender Viewer sender, @Arg Player target, @Arg Location location) {
        location.setWorld(target.getWorld());
        Formatter formatter = this.formatter(target, location);
        this.teleportService.teleport(target, location);
        this.noticeService.viewer(sender, translation -> translation.teleport().teleportedSpecifiedPlayerToCoordinates(), new Formatter[]{formatter});
    }

    @Execute
    @DescriptionDocs(description={"Teleport player to specified player, location and world"}, arguments={"<player> <x> <y> <z> <world>"})
    void to(@Sender Viewer sender, @Arg Player target, @Arg Location location, @Arg World world) {
        location.setWorld(world);
        Formatter formatter = this.formatter(target, location);
        this.teleportService.teleport(target, location);
        this.noticeService.viewer(sender, translation -> translation.teleport().teleportedSpecifiedPlayerToCoordinates(), new Formatter[]{formatter});
    }

    private Formatter formatter(Player player, Location location) {
        return CONTEXT.toFormatter(new TeleportContext(player, location));
    }

    private record TeleportContext(Player player, Location location) {
    }
}

