/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.spawn;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.annotations.scan.permission.PermissionDocs;
import com.eternalcode.core.feature.spawn.SpawnJoinSettings;
import com.eternalcode.core.feature.spawn.SpawnService;
import com.eternalcode.core.feature.teleport.TeleportService;
import com.eternalcode.core.feature.teleport.TeleportTaskService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import java.time.Duration;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@Command(name="spawn")
class SpawnCommand {
    private static final String SPAWN_TELEPORT_BYPASS = "eternalcore.spawn.bypass";
    private final TeleportTaskService teleportTaskService;
    private final SpawnJoinSettings spawnJoinSettings;
    private final TeleportService teleportService;
    private final NoticeService noticeService;
    private final SpawnService spawnService;

    @Inject
    SpawnCommand(TeleportTaskService teleportTaskService, SpawnJoinSettings spawnJoinSettings, TeleportService teleportService, NoticeService noticeService, SpawnService spawnService) {
        this.teleportTaskService = teleportTaskService;
        this.spawnJoinSettings = spawnJoinSettings;
        this.teleportService = teleportService;
        this.noticeService = noticeService;
        this.spawnService = spawnService;
    }

    @Execute
    @Permission(value={"eternalcore.spawn"})
    @DescriptionDocs(description={"Teleports you to spawn location"})
    @PermissionDocs(name="Spawn teleport bypass", permission={"eternalcore.spawn.bypass"}, description={"Allows you to bypass spawn teleportation time"})
    void executeSelf(@Sender Player sender) {
        Location spawnLocation = this.spawnService.getSpawnLocation();
        if (spawnLocation == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.spawn().spawnNoSet())).player(sender.getUniqueId())).send();
            return;
        }
        if (sender.hasPermission(SPAWN_TELEPORT_BYPASS)) {
            this.teleportService.teleport(sender, spawnLocation);
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleported())).player(sender.getUniqueId())).send();
            return;
        }
        if (this.teleportTaskService.isInTeleport(sender.getUniqueId())) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleportTaskAlreadyExist())).player(sender.getUniqueId())).send();
            return;
        }
        Duration teleportDelay = this.spawnJoinSettings.spawnTeleportTime();
        this.teleportTaskService.createTeleport(sender.getUniqueId(), PositionAdapter.convert((Location)sender.getLocation()), PositionAdapter.convert((Location)spawnLocation), teleportDelay);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.teleport().teleporting())).player(sender.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.spawn.other"})
    @DescriptionDocs(description={"Teleports specified player to spawn location"}, arguments={"<player>"})
    void execute(@Sender Viewer sender, @Arg Player player) {
        Location spawnLocation = this.spawnService.getSpawnLocation();
        if (spawnLocation == null) {
            ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.spawn().spawnNoSet())).viewer(sender)).send();
            return;
        }
        this.teleportService.teleport(player, spawnLocation);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.spawn().spawnTeleportedBy())).placeholder("{PLAYER}", sender.getName())).player(player.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.spawn().spawnTeleportedOther())).placeholder("{PLAYER}", player.getName())).viewer(sender)).send();
    }
}

