/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.skull;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.dev.rollczi.liteskullapi.SkullAPI;
import com.eternalcode.core.libs.dev.triumphteam.gui.builder.item.ItemBuilder;
import com.eternalcode.core.libs.dev.triumphteam.gui.builder.item.SkullBuilder;
import com.eternalcode.core.libs.net.kyori.adventure.text.Component;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Command(name="skull")
@Permission(value={"eternalcore.skull"})
class SkullCommand {
    private final NoticeService noticeService;
    private final SkullAPI skullAPI;

    @Inject
    SkullCommand(NoticeService noticeService, SkullAPI skullAPI) {
        this.skullAPI = skullAPI;
        this.noticeService = noticeService;
    }

    @Execute
    @DescriptionDocs(description={"Gives you a skull of player"}, arguments={"<player>"})
    void execute(@Sender Player sender, @Arg(value="player") String name) {
        this.skullAPI.acceptSkullData(name, skull -> {
            ItemStack namedSkull = ((SkullBuilder)ItemBuilder.skull().name((Component)Component.text((String)name))).texture(skull.getValue()).build();
            ItemStack mainHand = sender.getInventory().getItemInMainHand();
            if (mainHand.getType() == Material.PLAYER_HEAD) {
                mainHand.setItemMeta(namedSkull.getItemMeta());
            } else {
                sender.getInventory().addItem(new ItemStack[]{namedSkull});
            }
            ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.skull().playerSkullReceived())).placeholder("{SKULL}", name)).player(sender.getUniqueId())).send();
        });
    }
}

