/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.fun.catboy;

import com.eternalcode.core.feature.butcher.ButcherEntityRemoveEvent;
import com.eternalcode.core.feature.catboy.Catboy;
import com.eternalcode.core.feature.catboy.CatboyService;
import com.eternalcode.core.feature.fun.catboy.CatBoyEntityService;
import com.eternalcode.core.feature.teleport.event.EternalTeleportEvent;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import com.eternalcode.core.publish.Subscribe;
import com.eternalcode.core.publish.event.EternalShutdownEvent;
import java.time.Duration;
import java.util.Optional;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@Controller
class CatboyController
implements Listener {
    private static final Duration TICK = Duration.ofMillis(50L);
    private final CatboyService catboyService;
    private final CatBoyEntityService catBoyEntityService;
    private final Scheduler scheduler;
    private final Server server;

    @Inject
    CatboyController(CatboyService catboyService, CatBoyEntityService catBoyEntityService, Scheduler scheduler, Server server) {
        this.catboyService = catboyService;
        this.catBoyEntityService = catBoyEntityService;
        this.scheduler = scheduler;
        this.server = server;
    }

    @EventHandler
    void onCatboyEvent(PlayerQuitEvent event) {
        this.catboyService.unmarkAsCatboy(event.getPlayer());
    }

    @EventHandler
    void onCatboyEvent(EntityDismountEvent event) {
        Entity entity = event.getDismounted();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)entity2;
        if (this.catboyService.isCatboy(player.getUniqueId())) {
            cat.remove();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onTeleport(EternalTeleportEvent event) {
        Optional<Catboy> optionalCatboy = this.catboyService.getCatboy(event.getPlayer().getUniqueId());
        if (optionalCatboy.isPresent()) {
            Catboy catboy = optionalCatboy.get();
            this.catboyService.unmarkAsCatboy(event.getPlayer());
            this.scheduler.runLater(() -> this.catboyService.markAsCatboy(event.getPlayer(), catboy.selectedType()), TICK);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onHit(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player damager = (Player)entity2;
        World world = player.getWorld();
        if (this.catboyService.isCatboy(player.getUniqueId())) {
            world.playSound(player.getLocation(), Sound.ENTITY_CAT_PURREOW, 1.0f, 1.0f);
        }
        if (this.catboyService.isCatboy(damager.getUniqueId())) {
            world.playSound(damager.getLocation(), Sound.ENTITY_CAT_AMBIENT, 1.0f, 1.0f);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onEntityRemoveFromWorld(ButcherEntityRemoveEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)entity;
        if (this.catBoyEntityService.isCatboy(cat)) {
            event.setCancelled(true);
        }
    }

    @Subscribe
    void onServerShutdown(EternalShutdownEvent event) {
        for (Player onlinePlayer : this.server.getOnlinePlayers()) {
            boolean catboy = this.catboyService.isCatboy(onlinePlayer.getUniqueId());
            if (!catboy) continue;
            this.catboyService.unmarkAsCatboy(onlinePlayer);
        }
    }
}

