/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.container;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.paper.PaperContainer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="grindstone")
class GrindstoneCommand {
    private final NoticeService announcer;

    @Inject
    GrindstoneCommand(NoticeService announcer) {
        this.announcer = announcer;
    }

    @Execute
    @Permission(value={"eternalcore.grindstone"})
    @DescriptionDocs(description={"Opens a grindstone for you"})
    void executeSelf(@Sender Player player) {
        this.openGrindstone(player);
    }

    @Execute
    @Permission(value={"eternalcore.grindstone.other"})
    @DescriptionDocs(description={"Opens a grindstone for another player"}, arguments={"<player>"})
    void execute(@Sender CommandSender commandSender, @Arg Player target) {
        this.openGrindstone(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.announcer.create().notice(translation -> translation.container().targetGrindstoneOpened())).sender(commandSender).placeholder("{PLAYER}", target.getName())).send();
    }

    void openGrindstone(Player target) {
        PaperContainer.GRINDSTONE.open(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.announcer.create().notice(translation -> translation.container().grindstoneOpened())).player(target.getUniqueId())).send();
    }
}

