/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.compatibility;

import com.eternalcode.core.compatibility.Compatibility;
import com.eternalcode.core.compatibility.Version;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;

public class CompatibilityService {
    public boolean isCompatible(Class<?> type) {
        int patch;
        Compatibility compatibility = type.getAnnotation(Compatibility.class);
        if (compatibility == null) {
            return true;
        }
        Version from = compatibility.from();
        Version to = compatibility.to();
        int minor = PaperLib.getMinecraftVersion();
        return this.isCompatibleFrom(from, minor, patch = PaperLib.getMinecraftPatchVersion()) && this.isCompatibleTo(to, minor, patch);
    }

    private boolean isCompatibleTo(Version to, int minor, int patch) {
        return minor < to.minor() || minor == to.minor() && patch <= to.patch();
    }

    private boolean isCompatibleFrom(Version from, int minor, int patch) {
        return minor > from.minor() || minor == from.minor() && patch >= from.patch();
    }
}

