/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.litecommand.argument;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import com.eternalcode.core.user.User;
import com.eternalcode.core.user.UserManager;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;

@LiteArgument(type=User.class)
class UserArgument
extends AbstractViewerArgument<User> {
    private final Server server;
    private final UserManager userManager;

    @Inject
    UserArgument(TranslationManager translationManager, Server server, UserManager userManager) {
        super(translationManager);
        this.server = server;
        this.userManager = userManager;
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<User> argument, SuggestionContext context) {
        return (SuggestionResult)this.server.getOnlinePlayers().stream().map(HumanEntity::getName).collect(SuggestionResult.collector());
    }

    @Override
    public ParseResult<User> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        return (ParseResult)this.userManager.getUser(argument).map(ParseResult::success).orElseGet(() -> ParseResult.failure((Object)translation.argument().offlinePlayer()));
    }
}

