/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.warp.inventory;

import com.eternalcode.core.configuration.ConfigurationManager;
import com.eternalcode.core.feature.warp.WarpInventoryItem;
import com.eternalcode.core.feature.warp.inventory.WarpInventoryConfig;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Service;
import com.eternalcode.core.libs.com.eternalcode.commons.scheduler.Scheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Service
public class WarpInventoryConfigService {
    private final WarpInventoryConfig config;
    private final ConfigurationManager configurationManager;
    private final Scheduler scheduler;

    @Inject
    public WarpInventoryConfigService(ConfigurationManager configurationManager, WarpInventoryConfig config, Scheduler scheduler) {
        this.configurationManager = configurationManager;
        this.config = config;
        this.scheduler = scheduler;
    }

    public CompletableFuture<WarpInventoryConfigData> getWarpInventoryData() {
        return this.scheduler.completeAsync(() -> new HashMap<String, WarpInventoryItem>(this.config.items())).thenApply(items -> new WarpInventoryConfigData(this.config.display().title(), this.config.border(), this.config.decorationItems(), (Map<String, WarpInventoryItem>)items));
    }

    public CompletableFuture<Void> addWarpItem(String warpName, WarpInventoryItem item) {
        return this.scheduler.completeAsync(() -> {
            this.config.items().put(warpName, item);
            this.configurationManager.save(this.config);
            return null;
        });
    }

    public CompletableFuture<WarpInventoryItem> removeWarpItem(String warpName) {
        if (this.isBlank(warpName)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.scheduler.completeAsync(() -> this.config.items().get(warpName)).thenCompose(item -> {
            if (item == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.scheduler.completeAsync(() -> {
                this.config.items().remove(warpName);
                this.configurationManager.save(this.config);
                return null;
            }).thenApply(v -> item);
        });
    }

    public CompletableFuture<Void> save() {
        return this.scheduler.completeAsync(() -> {
            this.configurationManager.save(this.config);
            return null;
        });
    }

    public Map<String, WarpInventoryItem> getWarpItems() {
        return new HashMap<String, WarpInventoryItem>(this.config.items());
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public record WarpInventoryConfigData(String title, WarpInventoryConfig.BorderSection border, WarpInventoryConfig.DecorationItemsSection decorationItems, Map<String, WarpInventoryItem> items) {
    }
}

