/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.teleportrequest;

import com.eternalcode.core.feature.teleportrequest.TeleportRequestService;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.lite.LiteArgument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.Argument;
import com.eternalcode.core.libs.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.eternalcode.core.libs.dev.rollczi.litecommands.invocation.Invocation;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.eternalcode.core.libs.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.eternalcode.core.litecommand.argument.AbstractViewerArgument;
import com.eternalcode.core.translation.Translation;
import com.eternalcode.core.translation.TranslationManager;
import java.util.Objects;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

@LiteArgument(type=Player.class, name="requester")
class RequesterArgument
extends AbstractViewerArgument<Player> {
    static final String KEY = "requester";
    private final TeleportRequestService requestService;
    private final Server server;

    @Inject
    RequesterArgument(TeleportRequestService requestService, TranslationManager translationManager, Server server) {
        super(translationManager);
        this.requestService = requestService;
        this.server = server;
    }

    @Override
    public ParseResult<Player> parse(Invocation<CommandSender> invocation, String argument, Translation translation) {
        Player target = this.server.getPlayer(argument);
        Object object = invocation.sender();
        if (!(object instanceof Player)) {
            return ParseResult.failure((Object)translation.argument().onlyPlayer());
        }
        Player player = (Player)object;
        if (target == null || !this.requestService.hasRequest(target.getUniqueId(), player.getUniqueId())) {
            return ParseResult.failure((Object)translation.tpa().tpaDenyNoRequestMessage());
        }
        return ParseResult.success((Object)target);
    }

    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<Player> argument, SuggestionContext context) {
        Object object = invocation.sender();
        if (!(object instanceof Player)) {
            return SuggestionResult.empty();
        }
        Player player = (Player)object;
        return (SuggestionResult)this.requestService.findRequests(player.getUniqueId()).stream().map(arg_0 -> ((Server)this.server).getPlayer(arg_0)).filter(Objects::nonNull).map(HumanEntity::getName).collect(SuggestionResult.collector());
    }
}

