/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.spawn;

import com.eternalcode.core.configuration.implementation.LocationsConfiguration;
import com.eternalcode.core.feature.spawn.SpawnJoinSettings;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.injector.annotations.component.Controller;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.Position;
import com.eternalcode.core.libs.com.eternalcode.commons.bukkit.position.PositionAdapter;
import com.eternalcode.core.libs.io.papermc.lib.PaperLib;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@Controller
public class SpawnTeleportJoinController
implements Listener {
    private static final String WARNING = "Spawn is not set! Set it using the /setspawn command";
    private final Logger logger;
    private final LocationsConfiguration locationsConfiguration;
    private final SpawnJoinSettings spawnJoinSettings;
    private boolean warningShown = false;

    @Inject
    public SpawnTeleportJoinController(LocationsConfiguration locationsConfiguration, SpawnJoinSettings spawnJoinSettings, Logger logger) {
        this.locationsConfiguration = locationsConfiguration;
        this.spawnJoinSettings = spawnJoinSettings;
        this.logger = logger;
    }

    @EventHandler
    void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            if (this.spawnJoinSettings.teleportNewPlayersToSpawn()) {
                this.teleportToSpawn(player);
            }
            return;
        }
        if (this.spawnJoinSettings.teleportPlayersToSpawnOnJoin()) {
            this.teleportToSpawn(player);
        }
    }

    void teleportToSpawn(Player player) {
        Position spawnPosition = this.locationsConfiguration.spawn;
        if (spawnPosition == null || spawnPosition.isNoneWorld()) {
            if (!this.warningShown) {
                this.logger.warning(WARNING);
                this.warningShown = true;
            }
            return;
        }
        Location spawnLocation = PositionAdapter.convert((Position)spawnPosition);
        PaperLib.teleportAsync((Entity)player, (Location)spawnLocation);
    }
}

