/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.freeze;

import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.com.eternalcode.commons.time.DurationTickUtil;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Context;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.util.DurationUtil;
import java.time.Duration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(name="freeze")
@Permission(value={"eternalcore.freeze"})
public class FreezeCommand {
    private final NoticeService noticeService;

    @Inject
    public FreezeCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    public void freezeSelf(@Context Player player, @Arg Duration duration) {
        this.freezePlayer(player, duration);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.freeze().frozenSelf())).placeholder("{DURATION}", DurationUtil.format(duration, true))).player(player.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.freeze.other"})
    public void freezeOther(@Context CommandSender sender, @Arg Player target, @Arg Duration duration) {
        this.freezePlayer(target, duration);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.freeze().frozenOther())).placeholder("{PLAYER}", target.getName())).placeholder("{DURATION}", DurationUtil.format(duration, true))).sender(sender).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.freeze().frozenByOther())).placeholder("{PLAYER}", sender.getName())).placeholder("{DURATION}", DurationUtil.format(duration, true))).player(target.getUniqueId())).send();
    }

    private void freezePlayer(Player player, Duration duration) {
        int ticks = DurationTickUtil.durationToTicks((Duration)duration);
        player.setFreezeTicks(ticks);
    }
}

