/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core.feature.feed;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.argument.Arg;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.notice.EternalCoreBroadcast;
import com.eternalcode.core.notice.NoticeService;
import com.eternalcode.core.viewer.Viewer;
import org.bukkit.entity.Player;

@Command(name="feed")
class FeedCommand {
    private final NoticeService noticeService;

    @Inject
    FeedCommand(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    @Execute
    @Permission(value={"eternalcore.feed"})
    @DescriptionDocs(description={"Feed yourself"})
    void execute(@Sender Player player) {
        this.feed(player);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.feed().fed())).player(player.getUniqueId())).send();
    }

    @Execute
    @Permission(value={"eternalcore.feed.other"})
    @DescriptionDocs(description={"Feed other player"}, arguments={"<player>"})
    void execute(@Sender Viewer viewer, @Arg Player target) {
        this.feed(target);
        ((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.feed().fedByAdmin())).player(target.getUniqueId())).send();
        ((EternalCoreBroadcast)((EternalCoreBroadcast)((EternalCoreBroadcast)this.noticeService.create().notice(translation -> translation.feed().fedTargetPlayer())).placeholder("{PLAYER}", target.getName())).viewer(viewer)).send();
    }

    void feed(Player player) {
        player.setFoodLevel(20);
    }
}

