/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.core;

import com.eternalcode.annotations.scan.command.DescriptionDocs;
import com.eternalcode.core.configuration.ConfigurationManager;
import com.eternalcode.core.injector.annotations.Inject;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.async.Async;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.command.Command;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.context.Sender;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.execute.Execute;
import com.eternalcode.core.libs.dev.rollczi.litecommands.annotations.permission.Permission;
import com.eternalcode.core.libs.net.kyori.adventure.audience.Audience;
import com.eternalcode.core.libs.net.kyori.adventure.text.Component;
import com.eternalcode.core.libs.net.kyori.adventure.text.minimessage.MiniMessage;
import com.eternalcode.core.publish.Publisher;
import com.eternalcode.core.publish.event.EternalReloadEvent;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;

@Command(name="eternalcore")
@Permission(value={"eternalcore.eternalcore"})
class EternalCoreCommand {
    private static final String RELOAD_MESSAGE = "<b><gradient:#29fbff:#38b3ff>EternalCore:</gradient></b> <color:#9d6eef>Configuration has been successfully reloaded in %d ms.</color:#9d6eef>";
    private final ConfigurationManager configurationManager;
    private final MiniMessage miniMessage;
    private final Publisher publisher;

    @Inject
    EternalCoreCommand(ConfigurationManager configurationManager, MiniMessage miniMessage, Publisher publisher) {
        this.configurationManager = configurationManager;
        this.miniMessage = miniMessage;
        this.publisher = publisher;
    }

    @Async
    @Execute(name="reload")
    @DescriptionDocs(description={"Reloads EternalCore configuration"})
    void reload(@Sender Audience audience) {
        long millis = this.reload();
        Component message = this.miniMessage.deserialize((Object)RELOAD_MESSAGE.formatted(millis));
        audience.sendMessage(message);
    }

    private long reload() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.configurationManager.reload();
        this.publisher.publish(new EternalReloadEvent());
        return stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }
}

