/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer;

import com.eternalcode.combat.libs.eu.okaeri.configs.exception.OkaeriException;
import com.eternalcode.combat.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.eternalcode.combat.libs.eu.okaeri.configs.serdes.SerializationData;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.itemstack.ItemStackFailsafe;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.itemstack.ItemStackFormat;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.itemstack.ItemStackSpecData;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer.ItemMetaSerializer;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer.experimental.CraftItemStackSerializer;
import com.eternalcode.combat.libs.eu.okaeri.configs.yaml.bukkit.serdes.transformer.experimental.StringBase64ItemStackTransformer;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackSerializer
implements ObjectSerializer<ItemStack> {
    private static final ItemMetaSerializer ITEM_META_SERIALIZER = new ItemMetaSerializer();
    private static final StringBase64ItemStackTransformer ITEM_STACK_TRANSFORMER = new StringBase64ItemStackTransformer();
    private static final CraftItemStackSerializer CRAFT_ITEM_STACK_SERIALIZER = new CraftItemStackSerializer(true);
    private ItemStackFailsafe failsafe = ItemStackFailsafe.NONE;

    @Deprecated
    public ItemStackSerializer(boolean failsafe) {
        this.failsafe = failsafe ? ItemStackFailsafe.BASE64 : ItemStackFailsafe.NONE;
    }

    public ItemStackSerializer(@NonNull ItemStackFailsafe failsafe) {
        if (failsafe == null) {
            throw new NullPointerException("failsafe is marked non-null but is null");
        }
        this.failsafe = failsafe;
    }

    @Override
    public boolean supports(@NonNull Class<? super ItemStack> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ItemStack.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull ItemStack itemStack, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.add("material", itemStack.getType());
        if (itemStack.getAmount() != 1) {
            data.add("amount", itemStack.getAmount());
        }
        if (itemStack.getDurability() != 0) {
            data.add("durability", itemStack.getDurability());
        }
        ItemStackFormat format = data.getContext().getAttachment(ItemStackSpecData.class).map(ItemStackSpecData::getFormat).orElse(ItemStackFormat.NATURAL);
        if (!itemStack.hasItemMeta()) {
            return;
        }
        switch (format) {
            case NATURAL: {
                data.add("meta", (Object)itemStack.getItemMeta(), ItemMeta.class);
                break;
            }
            case COMPACT: {
                ITEM_META_SERIALIZER.serialize(itemStack.getItemMeta(), data, generics);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + (Object)((Object)format));
            }
        }
        if (this.failsafe == ItemStackFailsafe.NONE) {
            return;
        }
        DeserializationData deserializationData = new DeserializationData(data.asMap(), data.getConfigurer(), data.getContext());
        ItemStack deserializedStack = this.deserialize(deserializationData, generics);
        if (CraftItemStackSerializer.compareDeep(deserializedStack, itemStack)) {
            return;
        }
        data.clear();
        if (this.failsafe == ItemStackFailsafe.BUKKIT) {
            CRAFT_ITEM_STACK_SERIALIZER.serialize(itemStack, data, generics);
            return;
        }
        if (this.failsafe == ItemStackFailsafe.BASE64) {
            String base64Stack = ITEM_STACK_TRANSFORMER.leftToRight(itemStack, data.getContext());
            data.add("base64", base64Stack);
            return;
        }
        throw new OkaeriException("Unknown failsafe: " + (Object)((Object)this.failsafe));
    }

    @Override
    public ItemStack deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        ItemMeta itemMeta;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (data.getValueRaw() instanceof ItemStack) {
            return (ItemStack)data.getValueRaw();
        }
        if ("org.bukkit.inventory.ItemStack".equals(data.get("==", String.class)) || data.containsKey("v") && data.containsKey("type") || data.containsKey("DataVersion") && data.containsKey("id")) {
            return CRAFT_ITEM_STACK_SERIALIZER.deserialize(data, generics);
        }
        if (data.containsKey("base64")) {
            String base64Stack = data.get("base64", String.class);
            return ITEM_STACK_TRANSFORMER.rightToLeft(base64Stack, data.getContext());
        }
        if (!data.containsKey("material")) {
            throw new IllegalArgumentException("Invalid stack: " + data.asMap());
        }
        String materialName = data.get("material", String.class);
        Material material = Material.valueOf((String)materialName);
        int amount = data.containsKey("amount") ? data.get("amount", Integer.class) : 1;
        short durability = data.containsKey("durability") ? data.get("durability", Short.class) : (short)0;
        ItemStackFormat format = data.getContext().getAttachment(ItemStackSpecData.class).map(ItemStackSpecData::getFormat).orElse(ItemStackFormat.NATURAL);
        switch (format) {
            case NATURAL: {
                if (data.containsKey("display") || data.containsKey("display-name")) {
                    itemMeta = ITEM_META_SERIALIZER.deserialize(data, generics);
                    break;
                }
                itemMeta = data.containsKey("meta") ? data.get("meta", ItemMeta.class) : data.get("item-meta", ItemMeta.class);
                break;
            }
            case COMPACT: {
                if (data.containsKey("meta")) {
                    itemMeta = data.get("meta", ItemMeta.class);
                    break;
                }
                if (data.containsKey("item-meta")) {
                    itemMeta = data.get("item-meta", ItemMeta.class);
                    break;
                }
                itemMeta = ITEM_META_SERIALIZER.deserialize(data, generics);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + (Object)((Object)format));
            }
        }
        ItemStack itemStack = new ItemStack(material, amount);
        itemStack.setItemMeta(itemMeta);
        if (durability != 0) {
            itemStack.setDurability(durability);
        }
        return itemStack;
    }

    @Generated
    public ItemStackSerializer() {
    }
}

