/*
 * Decompiled with CFR 0.152.
 */
package com.eternalcode.combat.libs.dev.rollczi.litecommands.editor;

import com.eternalcode.combat.libs.dev.rollczi.litecommands.command.builder.CommandBuilder;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.editor.Editor;
import com.eternalcode.combat.libs.dev.rollczi.litecommands.scope.Scope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EditorService<SENDER> {
    private final Map<Scope, Editor<SENDER>> editorsByScope = new HashMap<Scope, Editor<SENDER>>();
    private final Set<Editor<SENDER>> globalEditors = new HashSet<Editor<SENDER>>();

    public CommandBuilder<SENDER> edit(CommandBuilder<SENDER> context) {
        for (Editor<SENDER> editor : this.globalEditors) {
            context = editor.edit(context);
        }
        for (Map.Entry entry : this.editorsByScope.entrySet()) {
            Scope scope = (Scope)entry.getKey();
            Editor editor = (Editor)entry.getValue();
            if (!scope.isApplicable(context)) continue;
            context = editor.edit(context);
        }
        if (context.isRoot()) {
            for (CommandBuilder commandBuilder2 : context.children()) {
                context.editChild(commandBuilder2.name(), commandBuilder -> this.edit((CommandBuilder<SENDER>)commandBuilder));
            }
        }
        return context;
    }

    public void editorGlobal(Editor<SENDER> editor) {
        this.globalEditors.add(editor);
    }

    public void editor(Scope scope, Editor<SENDER> editor) {
        this.editorsByScope.put(scope, editor);
    }
}

